/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.core.editor;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.wst.rdb.data.internal.core.common.PreparedStatementWriter;
import org.eclipse.wst.rdb.data.internal.core.editor.IRowData;
import org.eclipse.wst.rdb.data.internal.core.editor.ITableData;
import org.eclipse.wst.rdb.data.internal.core.editor.TableDataImpl;
import org.eclipse.wst.rdb.data.internal.core.editor.TableDataSaveStatus;

public class RowDataImpl
implements IRowData {
    protected TableDataImpl table;
    protected int state;
    public static final int STATE_ORIGINAL = 0;
    public static final int STATE_UPDATED = 1;
    public static final int STATE_DELETED = 2;
    public static final int STATE_INSERTED = 3;
    protected Object[] newData;
    protected Object[] oldData;

    public RowDataImpl(TableDataImpl table, int type, Object[] data) {
        this.table = table;
        this.state = type;
        this.newData = data;
        if (type == 0) {
            this.oldData = (Object[])data.clone();
        }
    }

    public ITableData getTable() {
        return this.table;
    }

    public Object getValue(int col) {
        return this.newData[col];
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void updateValue(int col, Object value) {
        if (this.state == 0) {
            this.state = 1;
        }
        this.newData[col] = value;
    }

    public void save(TableDataSaveStatus status) throws SQLException, IOException {
        switch (this.state) {
            case 1: {
                this.doUpdate(status);
                break;
            }
            case 3: {
                this.doInsert(status);
                break;
            }
            case 2: {
                this.doDelete(status);
            }
        }
    }

    protected void doInsert(TableDataSaveStatus status) throws SQLException, IOException {
        String q = "insert into " + this.table.getQualifiedTableName();
        q = String.valueOf(q) + " " + this.computeValuesClause();
        PreparedStatement pst = this.table.getConnection().prepareStatement(q);
        this.setValuesClauseArguments(pst, 0);
        pst.executeUpdate();
        pst.close();
        ++status.inserted;
    }

    protected void doUpdate(TableDataSaveStatus status) throws SQLException, IOException {
        String q = "update " + this.table.getQualifiedTableName();
        q = String.valueOf(q) + " " + this.computeSetClause();
        q = String.valueOf(q) + " " + this.computeWhereClause();
        PreparedStatement pst = this.table.getConnection().prepareStatement(q);
        int arg = 0;
        arg = this.setSetClauseArguments(pst, arg);
        arg = this.setWhereClauseArguments(pst, arg);
        int n = pst.executeUpdate();
        pst.close();
        status.updated += n;
        if (n != 1) {
            status.duplicateRow = true;
        }
    }

    protected void doDelete(TableDataSaveStatus status) throws SQLException, IOException {
        String q = "delete from " + this.table.getQualifiedTableName();
        q = String.valueOf(q) + " " + this.computeWhereClause();
        PreparedStatement pst = this.table.getConnection().prepareStatement(q);
        this.setWhereClauseArguments(pst, 0);
        int n = pst.executeUpdate();
        pst.close();
        status.deleted += n;
        if (n != 1) {
            status.duplicateRow = true;
        }
    }

    protected String computeValuesClause() {
        String q = "values(";
        int col = 0;
        while (col < this.newData.length) {
            q = String.valueOf(q) + (col == 0 ? "?" : ",?");
            ++col;
        }
        q = String.valueOf(q) + ")";
        return q;
    }

    protected int setValuesClauseArguments(PreparedStatement pst, int arg) throws SQLException, IOException {
        int col = 0;
        while (col < this.newData.length) {
            PreparedStatementWriter.write(pst, arg, this.table.getColumnType(col), this.newData[col]);
            ++arg;
            ++col;
        }
        return arg;
    }

    protected String computeSetClause() {
        String q = "set";
        boolean first = true;
        int col = 0;
        while (col < this.newData.length) {
            if (this.oldData[col] != this.newData[col]) {
                q = String.valueOf(q) + (first ? " " : ", ");
                q = String.valueOf(q) + this.table.getQuotedColumnName(col) + "=?";
                first = false;
            }
            ++col;
        }
        return q;
    }

    protected int setSetClauseArguments(PreparedStatement pst, int arg) throws SQLException, IOException {
        int col = 0;
        while (col < this.newData.length) {
            if (this.oldData[col] != this.newData[col]) {
                PreparedStatementWriter.write(pst, arg, this.table.getColumnType(col), this.newData[col]);
                ++arg;
            }
            ++col;
        }
        return arg;
    }

    protected String computeWhereClause() {
        String q = "where";
        int[] keyColumns = this.table.getKeyColumns();
        int i = 0;
        while (i < keyColumns.length) {
            q = String.valueOf(q) + (i == 0 ? " " : " AND ");
            q = String.valueOf(q) + this.table.getQuotedColumnName(keyColumns[i]);
            Object val = this.oldData[keyColumns[i]];
            q = val == null ? String.valueOf(q) + " is null" : String.valueOf(q) + "=?";
            ++i;
        }
        return q;
    }

    protected int setWhereClauseArguments(PreparedStatement pst, int arg) throws SQLException, IOException {
        int[] keyColumns = this.table.getKeyColumns();
        int i = 0;
        while (i < keyColumns.length) {
            if (this.oldData[keyColumns[i]] != null) {
                PreparedStatementWriter.write(pst, arg, this.table.getColumnType(i), this.oldData[keyColumns[i]]);
                ++arg;
            }
            ++i;
        }
        return arg;
    }

    public void resetToOriginal() {
        this.state = 0;
        this.oldData = (Object[])this.newData.clone();
    }

    public void revertToOriginal() {
        this.state = 0;
        this.newData = (Object[])this.oldData.clone();
    }
}

