/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.taginfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.taginfo.AnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.DebugInfoHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.ProblemAnnotationHoverProcessor;

public abstract class AbstractBestMatchHoverProcessor
implements ITextHover {
    private ITextHover fBestMatchHover;
    private List fTextHovers;

    protected List createTextHoversList() {
        ArrayList<Object> hoverList = new ArrayList<Object>();
        if (Logger.isTracing("debuginfohover")) {
            hoverList.add(new DebugInfoHoverProcessor());
        }
        hoverList.add(new ProblemAnnotationHoverProcessor());
        ITextHover taginfo = this.getTagInfoHover();
        if (taginfo != null) {
            hoverList.add(taginfo);
        }
        hoverList.add(new AnnotationHoverProcessor());
        return hoverList;
    }

    public String getHoverInfo(ITextViewer viewer, IRegion hoverRegion) {
        String displayText = null;
        if (this.fBestMatchHover != null) {
            displayText = this.fBestMatchHover.getHoverInfo(viewer, hoverRegion);
        }
        if (displayText == null) {
            Iterator i = this.getTextHovers().iterator();
            while (i.hasNext() && displayText == null) {
                ITextHover hover = (ITextHover)i.next();
                displayText = hover.getHoverInfo(viewer, hoverRegion);
            }
        }
        return displayText;
    }

    public IRegion getHoverRegion(ITextViewer viewer, int offset) {
        IRegion hoverRegion = null;
        ITextHover hover = null;
        Iterator i = this.getTextHovers().iterator();
        while (i.hasNext() && hoverRegion == null) {
            hover = (ITextHover)i.next();
            hoverRegion = hover.getHoverRegion(viewer, offset);
        }
        this.fBestMatchHover = hoverRegion != null ? hover : null;
        return hoverRegion;
    }

    protected abstract ITextHover getTagInfoHover();

    protected List getTextHovers() {
        if (this.fTextHovers == null) {
            this.fTextHovers = this.createTextHoversList();
        }
        return this.fTextHovers;
    }
}

