/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.selection;

import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.selection.SelectionHistory;
import org.eclipse.wst.sse.ui.internal.selection.StructureSelectAction;
import org.w3c.dom.Node;

public class StructureSelectPreviousAction
extends StructureSelectAction {
    public StructureSelectPreviousAction(StructuredTextEditor editor, SelectionHistory history) {
        super(editor, history);
        this.setText(SSEUIMessages.StructureSelectPrevious_label);
        this.setToolTipText(SSEUIMessages.StructureSelectPrevious_tooltip);
        this.setDescription(SSEUIMessages.StructureSelectPrevious_description);
    }

    protected IndexedRegion getCursorIndexedRegion() {
        return this.getIndexedRegion(this.fViewer.getSelectedRange().x);
    }

    protected Region getNewSelectionRegion(Node node, Region region) {
        Region newRegion = null;
        Node newNode = node.getPreviousSibling();
        if (newNode == null) {
            newNode = node.getParentNode();
            if (newNode instanceof IndexedRegion) {
                IndexedRegion newIndexedRegion = (IndexedRegion)newNode;
                newRegion = new Region(newIndexedRegion.getStartOffset(), newIndexedRegion.getEndOffset() - newIndexedRegion.getStartOffset());
            }
        } else if (newNode instanceof IndexedRegion) {
            IndexedRegion newIndexedRegion = (IndexedRegion)newNode;
            newRegion = new Region(newIndexedRegion.getStartOffset(), region.getOffset() + region.getLength() - newIndexedRegion.getStartOffset());
            if (newNode.getNodeType() == 3) {
                newRegion = this.getNewSelectionRegion(newNode, newRegion);
            }
        }
        return newRegion;
    }
}

