/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.selection;

import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.selection.SelectionHistory;
import org.eclipse.wst.sse.ui.internal.selection.StructureSelectAction;
import org.w3c.dom.Node;

public class StructureSelectNextAction
extends StructureSelectAction {
    public StructureSelectNextAction(StructuredTextEditor editor, SelectionHistory history) {
        super(editor, history);
        this.setText(SSEUIMessages.StructureSelectNext_label);
        this.setToolTipText(SSEUIMessages.StructureSelectNext_tooltip);
        this.setDescription(SSEUIMessages.StructureSelectNext_description);
    }

    protected IndexedRegion getCursorIndexedRegion() {
        int offset = this.fViewer.getSelectedRange().x + this.fViewer.getSelectedRange().y - 1;
        if (offset < 0) {
            offset = 0;
        }
        return this.getIndexedRegion(offset);
    }

    protected Region getNewSelectionRegion(Node node, Region region) {
        Region newRegion = null;
        Node newNode = node.getNextSibling();
        if (newNode == null) {
            newNode = node.getParentNode();
            if (newNode instanceof IndexedRegion) {
                IndexedRegion newIndexedRegion = (IndexedRegion)newNode;
                newRegion = new Region(newIndexedRegion.getStartOffset(), newIndexedRegion.getEndOffset() - newIndexedRegion.getStartOffset());
            }
        } else if (newNode instanceof IndexedRegion) {
            IndexedRegion newIndexedRegion = (IndexedRegion)newNode;
            newRegion = new Region(region.getOffset(), newIndexedRegion.getEndOffset() - region.getOffset());
            if (newNode.getNodeType() == 3) {
                newRegion = this.getNewSelectionRegion(newNode, newRegion);
            }
        }
        return newRegion;
    }
}

