/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class IncrementalReporter
implements IReporter {
    private IProgressMonitor fProgressMonitor;
    private HashMap messages = new HashMap();

    public IncrementalReporter(IProgressMonitor progressMonitor) {
        this.fProgressMonitor = progressMonitor;
    }

    public void addMessage(IValidator validator, IMessage message) {
        Object existingValue = this.messages.get(validator);
        if (existingValue != null) {
            ((List)existingValue).add(message);
        } else {
            ArrayList<IMessage> newValue = new ArrayList<IMessage>(1);
            newValue.add(message);
            this.messages.put(validator, newValue);
        }
    }

    public void displaySubtask(IValidator validator, IMessage message) {
        if (message == null || message.equals("")) {
            return;
        }
        if (this.fProgressMonitor != null) {
            this.fProgressMonitor.subTask(message.getText(validator.getClass().getClassLoader()));
        }
    }

    public List getMessages() {
        ArrayList result = new ArrayList();
        Object[] lists = this.messages.values().toArray();
        int i = 0;
        while (i < lists.length) {
            result.addAll((List)lists[i]);
            ++i;
        }
        return result;
    }

    public boolean isCancelled() {
        if (this.fProgressMonitor == null) {
            return false;
        }
        return this.fProgressMonitor.isCanceled();
    }

    public void removeAllMessages(IValidator validator) {
        Object o = this.messages.get(validator);
        if (o != null && o instanceof List) {
            ((List)o).clear();
        }
    }

    public void removeAllMessages(IValidator validator, Object object) {
        this.removeAllMessages(validator);
    }

    public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
        this.removeAllMessages(validator);
    }
}

