/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilableModel;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.ITemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.StructuredMarkerAnnotation;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentAdapter;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredReconcileStep;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;

public abstract class AbstractStructuredTextReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IReleasable {
    protected static final boolean DEBUG;
    public static final int ANNOTATION_LENGTH_LIMIT = 25;
    public static final int ELEMENT_ERROR_LIMIT = 25;
    protected IDocument fDocument = null;
    protected IReconcileStep fFirstStep = null;
    protected IProgressMonitor fProgressMonitor = null;
    protected ITextEditor fTextEditor = null;
    private Comparator fComparator;
    private HashSet fMarkerAnnotations = new HashSet();

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/reconcilerjob");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public AbstractStructuredTextReconcilingStrategy(ITextEditor editor) {
        this.fTextEditor = editor;
        this.init();
    }

    protected void addResultToAnnotationModel(IReconcileResult result) {
        if (!(result instanceof TemporaryAnnotation)) {
            return;
        }
        if (this.getAnnotationModel() != null) {
            TemporaryAnnotation tempAnnotation = (TemporaryAnnotation)result;
            StructuredMarkerAnnotation sma = this.getCorrespondingMarkerAnnotation(tempAnnotation);
            if (sma != null) {
                sma.setGrayed(false);
            }
            this.getAnnotationModel().addAnnotation((Annotation)tempAnnotation, tempAnnotation.getPosition());
        }
    }

    protected boolean canHandlePartition(String partition) {
        String[] haystack = this.getPartitionTypes();
        int i = 0;
        while (i < haystack.length) {
            if (haystack[i].equals(partition)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean containsStep(IReconcileStep step) {
        if (this.fFirstStep instanceof StructuredReconcileStep) {
            return ((StructuredReconcileStep)this.fFirstStep).isSiblingStep(step);
        }
        return false;
    }

    public abstract void createReconcileSteps();

    protected TemporaryAnnotation[] getAllAnnotationsToRemove() {
        ArrayList<ITemporaryAnnotation> removals = new ArrayList<ITemporaryAnnotation>();
        IAnnotationModel annotationModel = this.getAnnotationModel();
        if (annotationModel != null) {
            Iterator i = annotationModel.getAnnotationIterator();
            while (i.hasNext()) {
                ITemporaryAnnotation annotation;
                ReconcileAnnotationKey key;
                Object obj = i.next();
                if (!(obj instanceof ITemporaryAnnotation) || !this.canHandlePartition((key = (ReconcileAnnotationKey)(annotation = (ITemporaryAnnotation)obj).getKey()).getPartitionType()) || !this.containsStep(key.getStep())) continue;
                removals.add(annotation);
            }
        }
        return removals.toArray(new TemporaryAnnotation[removals.size()]);
    }

    protected IAnnotationModel getAnnotationModel() {
        IAnnotationModel model = null;
        if (this.fTextEditor != null && this.fTextEditor.getEditorInput() != null) {
            model = this.fTextEditor.getDocumentProvider().getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        }
        return model;
    }

    protected TemporaryAnnotation[] getAnnotationsToRemove(DirtyRegion dr) {
        IStructuredDocumentRegion[] sdRegions = this.getStructuredDocumentRegions(dr);
        ArrayList<TemporaryAnnotation> remove = new ArrayList<TemporaryAnnotation>();
        IAnnotationModel annotationModel = this.getAnnotationModel();
        if (this.getAnnotationModel() != null) {
            this.fMarkerAnnotations.clear();
            Iterator i = annotationModel.getAnnotationIterator();
            while (i.hasNext()) {
                TemporaryAnnotation annotation;
                ReconcileAnnotationKey key;
                StructuredMarkerAnnotation sma;
                Object obj = i.next();
                if (obj instanceof StructuredMarkerAnnotation && ((sma = (StructuredMarkerAnnotation)((Object)obj)).getAnnotationType() == "org.eclipse.wst.sse.ui.temp.error" || sma.getAnnotationType() == "org.eclipse.wst.sse.ui.temp.warning")) {
                    this.fMarkerAnnotations.add(sma);
                }
                if (!(obj instanceof TemporaryAnnotation) || !this.canHandlePartition((key = (ReconcileAnnotationKey)(annotation = (TemporaryAnnotation)obj).getKey()).getPartitionType()) || !this.containsStep(key.getStep())) continue;
                if (key.getScope() == 1 && this.overlaps(annotation.getPosition(), sdRegions)) {
                    remove.add(annotation);
                    continue;
                }
                if (key.getScope() != 0) continue;
                remove.add(annotation);
            }
        }
        return remove.toArray(new TemporaryAnnotation[remove.size()]);
    }

    /*
     * Exception decompiling
     */
    protected IndexedRegion getCorrespondingNode(IStructuredDocumentRegion sdRegion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 57->60)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IFile getFile() {
        if (this.fTextEditor == null) {
            return null;
        }
        IEditorInput input = this.fTextEditor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return null;
        }
        return ((IFileEditorInput)input).getFile();
    }

    public String[] getPartitionTypes() {
        if (this.fFirstStep instanceof StructuredReconcileStep) {
            return ((StructuredReconcileStep)this.fFirstStep).getPartitionTypes();
        }
        return new String[0];
    }

    private IStructuredDocumentRegion getStructuredDocumentRegion(int offset) {
        IStructuredDocumentRegion sdRegion = null;
        if (this.fDocument instanceof IStructuredDocument) {
            sdRegion = ((IStructuredDocument)this.fDocument).getRegionAtCharacterOffset(offset);
        }
        return sdRegion;
    }

    private IStructuredDocumentRegion[] getStructuredDocumentRegions(DirtyRegion dr) {
        int offset = dr.getOffset();
        int end = offset + dr.getLength();
        ArrayList<IStructuredDocumentRegion> regions = new ArrayList<IStructuredDocumentRegion>();
        IStructuredDocumentRegion r = this.getStructuredDocumentRegion(offset);
        while (r != null && r.getStartOffset() <= end) {
            if (!r.isDeleted()) {
                regions.add(r);
            }
            r = r.getNext();
        }
        return regions.toArray(new IStructuredDocumentRegion[regions.size()]);
    }

    public void init() {
        this.createReconcileSteps();
    }

    public void initialReconcile() {
    }

    protected boolean isCanceled() {
        if (DEBUG && this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
            System.out.println("** STRATEGY CANCELED **:" + this.getClass().getName());
        }
        return this.fProgressMonitor != null && this.fProgressMonitor.isCanceled();
    }

    protected boolean overlaps(Position pos, IStructuredDocumentRegion[] sdRegions) {
        int start = -1;
        int end = -1;
        int i = 0;
        while (i < sdRegions.length) {
            IndexedRegion corresponding;
            if (!sdRegions[i].isDeleted() && (corresponding = this.getCorrespondingNode(sdRegions[i])) != null) {
                if (start == -1 || start > corresponding.getStartOffset()) {
                    start = corresponding.getStartOffset();
                }
                if (end == -1 || end < corresponding.getEndOffset()) {
                    end = corresponding.getEndOffset();
                }
            }
            ++i;
        }
        return pos.overlapsWith(start, end - start);
    }

    private void process(IReconcileResult[] results) {
        if (DEBUG) {
            System.out.println("[trace reconciler] > STARTING PROCESS METHOD with (" + results.length + ") results");
        }
        if (results == null) {
            return;
        }
        int i = 0;
        while (i < results.length && i < 25 && !this.isCanceled()) {
            if (this.isCanceled()) {
                if (DEBUG) {
                    System.out.println("[trace reconciler] >** PROCESS (adding) WAS CANCELLED **");
                }
                return;
            }
            this.addResultToAnnotationModel(results[i]);
            ++i;
        }
        if (DEBUG) {
            StringBuffer traceString = new StringBuffer();
            int j = 0;
            while (j < results.length) {
                traceString.append("\n (+) :" + results[j] + ":\n");
                ++j;
            }
            System.out.println("[trace reconciler] > PROCESSING (" + results.length + ") results in AbstractStructuredTextReconcilingStrategy " + traceString);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        if (this.isCanceled() || this.fFirstStep == null) {
            return;
        }
        TemporaryAnnotation[] annotationsToRemove = new TemporaryAnnotation[]{};
        IReconcileResult[] annotationsToAdd = new IReconcileResult[]{};
        StructuredReconcileStep structuredStep = (StructuredReconcileStep)this.fFirstStep;
        annotationsToRemove = this.getAnnotationsToRemove(dirtyRegion);
        annotationsToAdd = structuredStep.reconcile(dirtyRegion, subRegion);
        this.smartProcess(annotationsToRemove, annotationsToAdd);
    }

    public void reconcile(IRegion partition) {
    }

    public void release() {
        if (this.fFirstStep != null && this.fFirstStep instanceof IReleasable) {
            ((IReleasable)this.fFirstStep).release();
        }
    }

    private void removeAnnotations(TemporaryAnnotation[] annotationsToRemove) {
        IAnnotationModel annotationModel = this.getAnnotationModel();
        if (annotationModel != null) {
            int i = 0;
            while (i < annotationsToRemove.length) {
                if (this.isCanceled()) {
                    if (DEBUG) {
                        System.out.println("[trace reconciler] >** REMOVAL WAS CANCELLED **");
                    }
                    return;
                }
                StructuredMarkerAnnotation sma = this.getCorrespondingMarkerAnnotation(annotationsToRemove[i]);
                if (sma != null) {
                    sma.setGrayed(true);
                }
                annotationModel.removeAnnotation((Annotation)annotationsToRemove[i]);
                ++i;
            }
        }
        if (DEBUG) {
            StringBuffer traceString = new StringBuffer();
            int i = 0;
            while (i < annotationsToRemove.length) {
                traceString.append("\n (-) :" + annotationsToRemove[i] + ":\n");
                ++i;
            }
            System.out.println("[trace reconciler] > REMOVED (" + annotationsToRemove.length + ") annotations in AbstractStructuredTextReconcilingStrategy :" + traceString);
        }
    }

    private StructuredMarkerAnnotation getCorrespondingMarkerAnnotation(TemporaryAnnotation tempAnnotation) {
        Iterator it = this.fMarkerAnnotations.iterator();
        while (it.hasNext()) {
            String message;
            StructuredMarkerAnnotation markerAnnotation;
            block3: {
                markerAnnotation = (StructuredMarkerAnnotation)((Object)it.next());
                message = "";
                try {
                    message = (String)markerAnnotation.getMarker().getAttribute("message");
                }
                catch (CoreException e) {
                    if (!DEBUG) break block3;
                    Logger.logException(e);
                }
            }
            if (message == null || !message.equals(tempAnnotation.getText())) continue;
            return markerAnnotation;
        }
        return null;
    }

    private void removeAllAnnotations() {
        this.removeAnnotations(this.getAllAnnotationsToRemove());
    }

    public void setDocument(IDocument document) {
        this.removeAllAnnotations();
        if (document == null) {
            this.release();
        }
        this.fDocument = document;
        if (this.fFirstStep != null) {
            this.fFirstStep.setInputModel((IReconcilableModel)new DocumentAdapter(document));
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
        if (this.fFirstStep != null) {
            this.fFirstStep.setProgressMonitor(this.fProgressMonitor);
        }
    }

    protected void smartProcess(TemporaryAnnotation[] annotationsToRemove, IReconcileResult[] annotationsToAdd) {
        Comparator comp = this.getAnnotationComparator();
        List<TemporaryAnnotation> sortedRemovals = Arrays.asList(annotationsToRemove);
        Collections.sort(sortedRemovals, comp);
        List<IReconcileResult> sortedAdditions = Arrays.asList(annotationsToAdd);
        Collections.sort(sortedAdditions, comp);
        ArrayList<TemporaryAnnotation> filteredRemovals = new ArrayList<TemporaryAnnotation>(sortedRemovals);
        ArrayList<IReconcileResult> filteredAdditions = new ArrayList<IReconcileResult>(sortedAdditions);
        boolean ignore = false;
        int lastFoundAdded = 0;
        int i = 0;
        while (i < sortedRemovals.size()) {
            TemporaryAnnotation removal = sortedRemovals.get(i);
            int j = lastFoundAdded;
            while (j < sortedAdditions.size()) {
                TemporaryAnnotation addition = (TemporaryAnnotation)sortedAdditions.get(j);
                if (removal.getPosition().equals((Object)addition.getPosition())) {
                    lastFoundAdded = j;
                    filteredAdditions.remove(addition);
                    ignore = true;
                    if (!DEBUG) break;
                    System.out.println(" ~ smart process ignoring: " + removal.getPosition().getOffset());
                    break;
                }
                ++j;
            }
            if (ignore) {
                filteredRemovals.remove(removal);
            }
            ignore = false;
            ++i;
        }
        this.removeAnnotations(filteredRemovals.toArray(new TemporaryAnnotation[filteredRemovals.size()]));
        this.process(filteredAdditions.toArray(new IReconcileResult[filteredAdditions.size()]));
    }

    private Comparator getAnnotationComparator() {
        if (this.fComparator == null) {
            this.fComparator = new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    TemporaryAnnotation ta1 = (TemporaryAnnotation)arg0;
                    TemporaryAnnotation ta2 = (TemporaryAnnotation)arg1;
                    return ta1.getPosition().getOffset() - ta2.getPosition().getOffset();
                }
            };
        }
        return this.fComparator;
    }

    public boolean isTotalScope() {
        return false;
    }
}

