/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.properties;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.ViewerSelectionManager;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapterFactory;
import org.eclipse.wst.sse.ui.internal.properties.RemoveAction;
import org.eclipse.wst.sse.ui.internal.provisional.views.properties.IPropertySourceExtension;
import org.eclipse.wst.sse.ui.internal.provisional.views.properties.PropertySheetConfiguration;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;

public class ConfigurablePropertySheetPage
extends PropertySheetPage
implements INodeSelectionListener {
    private PropertySheetConfiguration fConfiguration;
    private boolean fIsRealized = false;
    private IMenuManager fMenuManager;
    protected PageBook fParentPageBook = null;
    protected boolean fRefreshing = false;
    protected RemoveAction fRemoveAction;
    private IStatusLineManager fStatusLineManager;
    protected IStructuredModel fStructuredModel = null;
    private IToolBarManager fToolBarManager;
    private ViewerSelectionManager fViewerSelectionManager;
    private final PropertySheetConfiguration NULL_CONFIGURATION = new PropertySheetConfiguration();
    static /* synthetic */ Class class$0;

    public void createControl(Composite parent) {
        this.setPropertySourceProvider(this.getConfiguration().getPropertySourceProvider());
        super.createControl(parent);
        if (parent instanceof PageBook) {
            this.fParentPageBook = (PageBook)parent;
        }
    }

    public void dispose() {
        if (this.getViewerSelectionManager() != null) {
            this.getViewerSelectionManager().removeNodeSelectionListener(this);
        }
        this.setModel(null);
        this.setConfiguration(null);
        super.dispose();
    }

    public PropertySheetConfiguration getConfiguration() {
        if (this.fConfiguration == null) {
            this.fConfiguration = this.NULL_CONFIGURATION;
        }
        return this.fConfiguration;
    }

    public IStructuredModel getModel() {
        return this.fStructuredModel;
    }

    protected IJFaceNodeAdapterFactory getViewerRefreshFactory() {
        if (this.getModel() == null) {
            return null;
        }
        FactoryRegistry factoryRegistry = this.getModel().getFactoryRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IJFaceNodeAdapterFactory adapterFactory = (IJFaceNodeAdapterFactory)factoryRegistry.getFactoryFor((Object)clazz);
        return adapterFactory;
    }

    public ViewerSelectionManager getViewerSelectionManager() {
        return this.fViewerSelectionManager;
    }

    public void handleEntrySelection(ISelection selection) {
        if (this.fIsRealized && selection != null) {
            super.handleEntrySelection(selection);
            this.fRemoveAction.setEnabled(!selection.isEmpty());
        }
    }

    public boolean isRealized() {
        return this.fIsRealized;
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        this.fMenuManager = menuManager;
        this.fToolBarManager = toolBarManager;
        this.fStatusLineManager = statusLineManager;
        this.fRemoveAction = new RemoveAction(this);
        toolBarManager.add((IAction)this.fRemoveAction);
        menuManager.add((IAction)this.fRemoveAction);
        this.getConfiguration().addContributions(menuManager, toolBarManager, statusLineManager);
        menuManager.update(true);
        this.fIsRealized = true;
    }

    public void nodeSelectionChanged(NodeSelectionChangedEvent event) {
        this.selectionChanged(null, (ISelection)new StructuredSelection(event.getSelectedNodes()));
    }

    public void refresh() {
        if (!this.fRefreshing) {
            this.fRefreshing = true;
            super.refresh();
            this.fRefreshing = false;
        }
    }

    public void remove() {
        if (this.getControl() instanceof Tree) {
            Object data;
            TreeItem[] items = ((Tree)this.getControl()).getSelection();
            List selectedNodes = this.getViewerSelectionManager().getSelectedNodes();
            if (items != null && items.length == 1 && selectedNodes != null && (data = items[0].getData()) instanceof IPropertySheetEntry) {
                IPropertySource source;
                IPropertySheetEntry entry = (IPropertySheetEntry)data;
                ISelection selection = this.getConfiguration().getSelection(null, (ISelection)new StructuredSelection(selectedNodes));
                if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (source = this.getConfiguration().getPropertySourceProvider().getPropertySource(((IStructuredSelection)selection).getFirstElement())) != null && source instanceof IPropertySourceExtension) {
                    ((IPropertySourceExtension)source).removeProperty(entry.getDisplayName());
                }
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, this.getConfiguration().getSelection(part, selection));
    }

    public void setConfiguration(PropertySheetConfiguration configuration) {
        if (this.fConfiguration != null && this.isRealized()) {
            this.fConfiguration.removeContributions(this.fMenuManager, this.fToolBarManager, this.fStatusLineManager);
            this.fConfiguration.unconfigure();
        }
        this.fConfiguration = configuration;
        if (this.fConfiguration != null) {
            this.setPropertySourceProvider(this.fConfiguration.getPropertySourceProvider());
            if (this.isRealized()) {
                this.fConfiguration.addContributions(this.fMenuManager, this.fToolBarManager, this.fStatusLineManager);
            }
        }
    }

    public void setFocus() {
        super.setFocus();
        if (this.fParentPageBook != null) {
            this.fParentPageBook.showPage(this.getControl());
        }
    }

    public void setModel(IStructuredModel model) {
        if (model != this.fStructuredModel) {
            IJFaceNodeAdapterFactory refresher = this.getViewerRefreshFactory();
            if (refresher != null) {
                refresher.removeListener(this);
            }
            this.fStructuredModel = model;
            refresher = this.getViewerRefreshFactory();
            if (refresher != null) {
                refresher.addListener(this);
            }
        }
    }

    public void setViewerSelectionManager(ViewerSelectionManager viewerSelectionManager) {
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.removeNodeSelectionListener(this);
        }
        this.fViewerSelectionManager = viewerSelectionManager;
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.addNodeSelectionListener(this);
        }
    }
}

