/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.preferences.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.EditorPreferenceNames;
import org.eclipse.wst.sse.ui.internal.preferences.ui.IPreferenceTab;

public class TranslucencyPreferenceTab
implements IPreferenceTab {
    private PreferencePage fMainPreferencePage;
    private IntegerFieldEditor fTranslucencyScale = null;
    private final int MAX_PERCENTAGE = 100;
    private IPropertyChangeListener validityChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                TranslucencyPreferenceTab.this.updateValidState();
            }
        }
    };

    public TranslucencyPreferenceTab() {
    }

    public TranslucencyPreferenceTab(PreferencePage mainPreferencePage) {
        Assert.isNotNull((Object)mainPreferencePage);
        this.setMainPreferencePage(mainPreferencePage);
    }

    public Control createContents(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        String text = SSEUIMessages.TranslucencyPreferenceTab_1;
        this.fTranslucencyScale = new IntegerFieldEditor(EditorPreferenceNames.READ_ONLY_FOREGROUND_SCALE, text, composite);
        this.fTranslucencyScale.setErrorMessage(JFaceResources.getString((String)"StringFieldEditor.errorMessage"));
        this.fTranslucencyScale.setPreferenceStore(this.getPreferenceStore());
        this.fTranslucencyScale.setPreferencePage(this.getMainPreferencePage());
        this.fTranslucencyScale.setTextLimit(Integer.toString(100).length());
        this.fTranslucencyScale.setValidateStrategy(0);
        this.fTranslucencyScale.setValidRange(0, 100);
        this.fTranslucencyScale.load();
        this.fTranslucencyScale.setPropertyChangeListener(this.validityChangeListener);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.wst.sse.ui.webx0001");
        return composite;
    }

    private PreferencePage getMainPreferencePage() {
        return this.fMainPreferencePage;
    }

    private IPreferenceStore getPreferenceStore() {
        return SSEUIPlugin.getDefault().getPreferenceStore();
    }

    public String getTitle() {
        return SSEUIMessages.TranslucencyPreferenceTab_0;
    }

    public void performApply() {
        this.fTranslucencyScale.store();
        SSEUIPlugin.getDefault().savePluginPreferences();
    }

    public void performDefaults() {
        this.fTranslucencyScale.loadDefault();
    }

    public void performOk() {
        this.performApply();
    }

    private void setMainPreferencePage(PreferencePage mainPreferencePage) {
        this.fMainPreferencePage = mainPreferencePage;
    }

    private void updateValidState() {
        if (this.getMainPreferencePage() != null) {
            this.getMainPreferencePage().setValid(this.fTranslucencyScale.isValid());
        }
    }
}

