/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentoutline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.ViewerSelectionManager;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapterFactory;
import org.eclipse.wst.sse.ui.internal.contentoutline.SourceEditorTreeViewer;
import org.eclipse.wst.sse.ui.internal.provisional.views.contentoutline.ContentOutlineConfiguration;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.ITextSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.eclipse.wst.sse.ui.internal.view.events.TextSelectionChangedEvent;

public class StructuredTextEditorContentOutlinePage
extends ContentOutlinePage
implements INodeSelectionListener,
ITextSelectionListener,
IUpdate,
IAdaptable {
    protected static ContentOutlineConfiguration NULL_CONFIGURATION = new ContentOutlineConfiguration();
    private TransferDragSourceListener[] fActiveDragListeners;
    private TransferDropTargetListener[] fActiveDropListeners;
    private ContentOutlineConfiguration fConfiguration;
    private MenuManager fContextMenuManager;
    private boolean fContextMenuRegistered = false;
    private DelegatingDragAdapter fDragAdapter;
    private DragSource fDragSource;
    private DelegatingDropAdapter fDropAdapter;
    private DropTarget fDropTarget;
    protected IStructuredModel fModel;
    ISelection fSelection = StructuredSelection.EMPTY;
    protected SourceEditorTreeViewer fTreeViewer;
    protected ViewerSelectionManager fViewerSelectionManager;
    private IMenuListener fGroupAdder = new AdditionGroupAdder();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createControl(Composite parent) {
        this.fTreeViewer = new SourceEditorTreeViewer(new Tree(parent, 772));
        this.fContextMenuManager = new MenuManager("#popup");
        this.fContextMenuManager.setRemoveAllWhenShown(true);
        Menu menu = this.fContextMenuManager.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(menu);
        this.fDragAdapter = new DelegatingDragAdapter();
        this.fDragSource = new DragSource(this.fTreeViewer.getControl(), 7);
        this.fDropAdapter = new DelegatingDropAdapter();
        this.fDropTarget = new DropTarget(this.fTreeViewer.getControl(), 7);
        this.setConfiguration(this.getConfiguration());
        this.fTreeViewer.setInput(this.getModel());
        IJFaceNodeAdapterFactory adapterFactory = this.getViewerRefreshFactory();
        if (adapterFactory != null) {
            adapterFactory.addListener((Object)this.fTreeViewer);
        }
        if (this.getViewerSelectionManager() != null) {
            StructuredSelection selection;
            ArrayList selectedNodes = this.getViewerSelectionManager().getSelectedNodes();
            if (selectedNodes == null) {
                selectedNodes = new ArrayList(0);
            }
            if (!(selection = new StructuredSelection(this.getConfiguration().getNodes(selectedNodes))).isEmpty()) {
                this.setSelection((ISelection)selection, true);
            }
        }
        this.fTreeViewer.addInvalidSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                StructuredTextEditorContentOutlinePage.this.fSelection = selection;
            }
        });
        this.fTreeViewer.addPostSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void dispose() {
        IJFaceNodeAdapterFactory adapterFactory;
        super.dispose();
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.removeNodeSelectionListener(this);
        }
        if ((adapterFactory = this.getViewerRefreshFactory()) != null) {
            adapterFactory.removeListener((Object)this.fTreeViewer);
        }
        this.setConfiguration(NULL_CONFIGURATION);
    }

    public Object getAdapter(Class key) {
        Object adapter = this.getConfiguration().getAdapter(key);
        if (adapter == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (key.equals(clazz)) {
                adapter = new ShowInTarget();
            }
        }
        return adapter;
    }

    public ContentOutlineConfiguration getConfiguration() {
        if (this.fConfiguration == null) {
            return NULL_CONFIGURATION;
        }
        return this.fConfiguration;
    }

    public Control getControl() {
        if (this.getTreeViewer() == null) {
            return null;
        }
        return this.getTreeViewer().getControl();
    }

    protected IStructuredModel getModel() {
        return this.fModel;
    }

    protected List getSelectedNodes(NodeSelectionChangedEvent event) {
        return this.getConfiguration().getSelectedNodes(event);
    }

    public ISelection getSelection() {
        if (this.getTreeViewer() == null) {
            return StructuredSelection.EMPTY;
        }
        return this.getTreeViewer().getSelection();
    }

    protected TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    protected IJFaceNodeAdapterFactory getViewerRefreshFactory() {
        if (this.getModel() == null) {
            return null;
        }
        FactoryRegistry factoryRegistry = this.getModel().getFactoryRegistry();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IJFaceNodeAdapterFactory adapterFactory = (IJFaceNodeAdapterFactory)factoryRegistry.getFactoryFor((Object)clazz);
        return adapterFactory;
    }

    public ViewerSelectionManager getViewerSelectionManager() {
        return this.fViewerSelectionManager;
    }

    public void nodeSelectionChanged(NodeSelectionChangedEvent event) {
        List selectedNodes;
        if (this.getTreeViewer() != null && this.getConfiguration().isLinkedWithEditor(this.getTreeViewer()) && (selectedNodes = this.getSelectedNodes(event)) != null) {
            StructuredSelection selection = new StructuredSelection(selectedNodes);
            this.setSelection((ISelection)selection);
            int caretPosition = event.getCaretPosition();
            ((SourceEditorTreeViewer)this.getTreeViewer()).setCaretPosition(caretPosition);
        }
    }

    void registerContextMenu() {
        IEditorPart ownerEditor;
        IWorkbenchPage page;
        if (!this.fContextMenuRegistered && this.getTreeViewer() != null && this.getTreeViewer().getControl() != null && (page = this.getSite().getWorkbenchWindow().getActivePage()) != null && (ownerEditor = page.getActiveEditor()) != null) {
            this.fContextMenuRegistered = true;
            if (this.getModel() != null) {
                this.getSite().registerContextMenu(String.valueOf(this.getModel().getContentTypeIdentifier()) + ".source.OutlineContext", this.fContextMenuManager, (ISelectionProvider)this);
            } else {
                this.getSite().registerContextMenu(String.valueOf(ownerEditor.getSite().getId()) + ".OutlineContext", this.fContextMenuManager, (ISelectionProvider)this);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.fSelection.equals(event.getSelection())) {
            super.selectionChanged(event);
        }
    }

    public void setConfiguration(ContentOutlineConfiguration configuration) {
        int i;
        IMenuListener listener;
        if (this.fTreeViewer != null) {
            IContributionItem[] menuItems;
            IContributionItem[] toolbarItems;
            if (this.fTreeViewer.getControl() != null && !this.fTreeViewer.getControl().isDisposed()) {
                KeyListener[] listeners = this.getConfiguration().getKeyListeners(this.fTreeViewer);
                int i2 = 0;
                while (i2 < listeners.length) {
                    this.fTreeViewer.getControl().removeKeyListener(listeners[i2]);
                    ++i2;
                }
            }
            if (this.fContextMenuManager != null) {
                listener = this.getConfiguration().getMenuListener(this.fTreeViewer);
                if (listener != null) {
                    this.fContextMenuManager.removeMenuListener(listener);
                }
                this.fContextMenuManager.removeMenuListener(this.fGroupAdder);
            }
            if (this.getConfiguration().getSelectionChangedListener(this.fTreeViewer) != null) {
                this.removeSelectionChangedListener(this.getConfiguration().getSelectionChangedListener(this.fTreeViewer));
            }
            if (this.getConfiguration().getDoubleClickListener(this.fTreeViewer) != null) {
                this.fTreeViewer.removeDoubleClickListener(this.getConfiguration().getDoubleClickListener(this.fTreeViewer));
            }
            if ((toolbarItems = this.getConfiguration().getToolbarContributions(this.fTreeViewer)).length > 0 && this.getSite() != null && this.getSite().getActionBars() != null && this.getSite().getActionBars().getToolBarManager() != null) {
                IToolBarManager toolbar = this.getSite().getActionBars().getToolBarManager();
                int i3 = 0;
                while (i3 < toolbarItems.length) {
                    toolbar.remove(toolbarItems[i3]);
                    ++i3;
                }
                toolbar.update(false);
            }
            if ((menuItems = this.getConfiguration().getMenuContributions(this.fTreeViewer)).length > 0 && this.getSite().getActionBars().getMenuManager() != null) {
                IMenuManager menubar = this.getSite().getActionBars().getMenuManager();
                i = 0;
                while (i < menuItems.length) {
                    menubar.remove(menuItems[i]);
                    ++i;
                }
                menubar.remove("additions");
                menubar.update(false);
            }
            if (this.fDragAdapter != null && !this.fDragAdapter.isEmpty() && !this.fDragSource.isDisposed() && this.fDragSource.getTransfer().length > 0) {
                if (this.fActiveDragListeners != null) {
                    int i4 = 0;
                    while (i4 < this.fActiveDragListeners.length) {
                        this.fDragAdapter.removeDragSourceListener(this.fActiveDragListeners[i4]);
                        ++i4;
                    }
                }
                this.fActiveDragListeners = null;
                this.fDragSource.removeDragListener((DragSourceListener)this.fDragAdapter);
                this.fDragSource.setTransfer(new Transfer[0]);
            }
            if (this.fDropAdapter != null && !this.fDropAdapter.isEmpty() && !this.fDropTarget.isDisposed() && this.fDropTarget.getTransfer().length > 0) {
                if (this.fActiveDropListeners != null) {
                    int i5 = 0;
                    while (i5 < this.fActiveDropListeners.length) {
                        this.fDropAdapter.removeDropTargetListener(this.fActiveDropListeners[i5]);
                        ++i5;
                    }
                }
                this.fActiveDropListeners = null;
                this.fDropTarget.removeDropListener((DropTargetListener)this.fDropAdapter);
                this.fDropTarget.setTransfer(new Transfer[0]);
            }
            this.getConfiguration().unconfigure(this.fTreeViewer);
        }
        this.fConfiguration = configuration;
        if (this.fConfiguration == null) {
            this.fConfiguration = NULL_CONFIGURATION;
        }
        this.fSelection = StructuredSelection.EMPTY;
        if (this.fTreeViewer != null && this.fTreeViewer.getControl() != null && !this.fTreeViewer.getControl().isDisposed()) {
            int i6;
            IContributionItem[] menuItems;
            IMenuManager menu;
            IContributionItem[] toolbarItems;
            listener = this.getConfiguration().getMenuListener(this.fTreeViewer);
            if (listener != null) {
                this.fContextMenuManager.addMenuListener(listener);
            }
            this.fContextMenuManager.addMenuListener(this.fGroupAdder);
            this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.getConfiguration().getLabelProvider(this.fTreeViewer));
            this.fTreeViewer.setContentProvider(this.getConfiguration().getContentProvider(this.fTreeViewer));
            if (this.getConfiguration().getSelectionChangedListener(this.fTreeViewer) != null) {
                this.addSelectionChangedListener(this.getConfiguration().getSelectionChangedListener(this.fTreeViewer));
            }
            if (this.getConfiguration().getDoubleClickListener(this.fTreeViewer) != null) {
                this.fTreeViewer.addDoubleClickListener(this.getConfiguration().getDoubleClickListener(this.fTreeViewer));
            }
            if ((toolbarItems = this.getConfiguration().getToolbarContributions(this.fTreeViewer)).length > 0 && this.getSite() != null && this.getSite().getActionBars() != null && this.getSite().getActionBars().getToolBarManager() != null) {
                IToolBarManager toolbar = this.getSite().getActionBars().getToolBarManager();
                i = 0;
                while (i < toolbarItems.length) {
                    toolbar.add(toolbarItems[i]);
                    ++i;
                }
                toolbar.update(true);
            }
            if ((menu = this.getSite().getActionBars().getMenuManager()) != null && (menuItems = this.getConfiguration().getMenuContributions(this.fTreeViewer)).length > 0) {
                i6 = 0;
                while (i6 < menuItems.length) {
                    menuItems[i6].setVisible(true);
                    menu.add(menuItems[i6]);
                    menuItems[i6].update();
                    ++i6;
                }
                menu.update(true);
            }
            TransferDragSourceListener[] dragListeners = this.fConfiguration.getTransferDragSourceListeners(this.fTreeViewer);
            if (this.fDragAdapter != null && dragListeners.length > 0) {
                i6 = 0;
                while (i6 < dragListeners.length) {
                    this.fDragAdapter.addDragSourceListener(dragListeners[i6]);
                    ++i6;
                }
                this.fActiveDragListeners = dragListeners;
                this.fDragSource.addDragListener((DragSourceListener)this.fDragAdapter);
                this.fDragSource.setTransfer(this.fDragAdapter.getTransfers());
            }
            TransferDropTargetListener[] dropListeners = this.fConfiguration.getTransferDropTargetListeners(this.fTreeViewer);
            if (this.fDropAdapter != null && dropListeners.length > 0) {
                int i7 = 0;
                while (i7 < dropListeners.length) {
                    this.fDropAdapter.addDropTargetListener(dropListeners[i7]);
                    ++i7;
                }
                this.fActiveDropListeners = dropListeners;
                this.fDropTarget.addDropListener((DropTargetListener)this.fDropAdapter);
                this.fDropTarget.setTransfer(this.fDropAdapter.getTransfers());
            }
            KeyListener[] listeners = this.getConfiguration().getKeyListeners(this.fTreeViewer);
            int i8 = 0;
            while (i8 < listeners.length) {
                this.fTreeViewer.getControl().addKeyListener(listeners[i8]);
                ++i8;
            }
        }
        this.registerContextMenu();
    }

    public void setFocus() {
        this.getTreeViewer().getControl().setFocus();
    }

    public void setModel(IStructuredModel newModel) {
        if (newModel != this.fModel) {
            IJFaceNodeAdapterFactory adapterFactory = this.getViewerRefreshFactory();
            if (adapterFactory != null) {
                adapterFactory.removeListener((Object)this.fTreeViewer);
            }
            this.fModel = newModel;
            if (this.getTreeViewer() != null && this.getControl() != null && !this.getControl().isDisposed()) {
                this.setConfiguration(this.getConfiguration());
                this.fTreeViewer.setInput(this.fModel);
                this.update();
            }
            if ((adapterFactory = this.getViewerRefreshFactory()) != null) {
                adapterFactory.addListener((Object)this.fTreeViewer);
            }
        }
    }

    void setRedraw(boolean doRedraw) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.setRedraw(doRedraw);
        }
    }

    public void setSelection(ISelection selection) {
        this.setSelection(selection, this.getConfiguration().isLinkedWithEditor(this.getTreeViewer()));
    }

    protected void setSelection(ISelection selection, boolean reveal) {
        if (this.getTreeViewer() != null && selection instanceof IStructuredSelection && !this.fSelection.equals(selection)) {
            this.fSelection = selection == null || ((IStructuredSelection)selection).getFirstElement() == null ? StructuredSelection.EMPTY : selection;
            this.getTreeViewer().setSelection(this.fSelection, reveal);
        }
    }

    public void setViewerSelectionManager(ViewerSelectionManager viewerSelectionManager) {
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.removeNodeSelectionListener(this);
            this.fViewerSelectionManager.removeTextSelectionListener(this);
        }
        this.fViewerSelectionManager = viewerSelectionManager;
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.addNodeSelectionListener(this);
            this.fViewerSelectionManager.addTextSelectionListener(this);
        }
    }

    public void textSelectionChanged(TextSelectionChangedEvent event) {
        if (this.getConfiguration().isLinkedWithEditor(this.getTreeViewer())) {
            int caretPosition = event.getTextSelectionStart();
            ((SourceEditorTreeViewer)this.getTreeViewer()).setCaretPosition(caretPosition);
        }
    }

    public void update() {
        if (this.getTreeViewer() != null) {
            Control control = this.getTreeViewer().getControl();
            control.setRedraw(false);
            this.getTreeViewer().refresh();
            control.setRedraw(true);
        }
    }

    protected class ControlRedrawEnabler
    implements IModelStateListener {
        protected ControlRedrawEnabler() {
        }

        public void modelAboutToBeChanged(IStructuredModel model) {
            this.setControlRedraw(false);
        }

        public void modelChanged(IStructuredModel model) {
            this.setControlRedraw(true);
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel originalmodel, IStructuredModel movedmodel) {
        }

        private void setControlRedraw(boolean doRedraw) {
            if (Display.getCurrent() != null) {
                StructuredTextEditorContentOutlinePage.this.setRedraw(doRedraw);
            } else {
                boolean redrawOrNot = doRedraw;
                Runnable modifyRedraw = new Runnable(this, redrawOrNot){
                    final /* synthetic */ ControlRedrawEnabler this$1;
                    private final /* synthetic */ boolean val$redrawOrNot;
                    {
                        this.this$1 = controlRedrawEnabler;
                        this.val$redrawOrNot = bl;
                    }

                    public void run() {
                        ControlRedrawEnabler.access$0(this.this$1).setRedraw(this.val$redrawOrNot);
                    }
                };
                Display.getDefault().asyncExec(modifyRedraw);
            }
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        }

        public void modelReinitialized(IStructuredModel structuredModel) {
        }

        static /* synthetic */ StructuredTextEditorContentOutlinePage access$0(ControlRedrawEnabler controlRedrawEnabler) {
            return controlRedrawEnabler.StructuredTextEditorContentOutlinePage.this;
        }
    }

    class ShowInTarget
    implements IShowInTarget {
        ShowInTarget() {
        }

        public boolean show(ShowInContext context) {
            StructuredSelection selection;
            if (StructuredTextEditorContentOutlinePage.this.getViewerSelectionManager() == null) {
                return false;
            }
            boolean shown = false;
            ArrayList selectedNodes = StructuredTextEditorContentOutlinePage.this.getViewerSelectionManager().getSelectedNodes();
            if (selectedNodes == null) {
                selectedNodes = new ArrayList(0);
            }
            if (!(selection = new StructuredSelection(StructuredTextEditorContentOutlinePage.this.getConfiguration().getNodes(selectedNodes))).isEmpty()) {
                StructuredTextEditorContentOutlinePage.this.setSelection((ISelection)selection, true);
                shown = selection.equals(StructuredTextEditorContentOutlinePage.this.fSelection);
            }
            return shown;
        }
    }

    class AdditionGroupAdder
    implements IMenuListener {
        AdditionGroupAdder() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            IContributionItem[] items = manager.getItems();
            if (items.length > 0 && items[items.length - 1].getId() != null) {
                manager.insertAfter(items[items.length - 1].getId(), (IContributionItem)new GroupMarker("additions"));
            } else {
                manager.add((IContributionItem)new GroupMarker("additions"));
            }
        }
    }
}

