/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentoutline;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextSelectionChangedEvent;

public class SourceEditorTreeViewer
extends TreeViewer {
    private int fCaretPosition;
    private ISelectionListener[] fInvalidSelectionListeners = null;

    public SourceEditorTreeViewer(Composite parent) {
        super(parent);
    }

    public SourceEditorTreeViewer(Tree tree) {
        super(tree);
    }

    public synchronized void addInvalidSelectionListener(ISelectionListener listener) {
        ISelectionListener[] newListeners = this.fInvalidSelectionListeners;
        if (this.fInvalidSelectionListeners != null && this.fInvalidSelectionListeners.length > 0) {
            ArrayList<ISelectionListener> oldListeners = new ArrayList<ISelectionListener>(Arrays.asList(this.fInvalidSelectionListeners));
            if (!oldListeners.contains(listener)) {
                oldListeners.add(listener);
                newListeners = oldListeners.toArray(new ISelectionListener[0]);
            }
        } else {
            newListeners = new ISelectionListener[]{listener};
        }
        this.fInvalidSelectionListeners = newListeners;
    }

    private void fireInvalidSelection(ISelection newSelection) {
        if (this.fInvalidSelectionListeners != null) {
            ISelectionListener[] listeners = this.fInvalidSelectionListeners;
            int i = 0;
            while (i < listeners.length) {
                listeners[i].selectionChanged(null, newSelection);
                ++i;
            }
        }
    }

    protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
        IStructuredModel model = (IStructuredModel)this.getInput();
        if (model != null) {
            IndexedRegion selectedNode = model.getIndexedRegion(this.fCaretPosition);
            if (selectedNode != null) {
                newSelection = new StructuredSelection((Object)selectedNode);
            }
            this.fireInvalidSelection(newSelection);
            this.setSelectionToWidget(newSelection, true);
        }
        super.handleInvalidSelection(invalidSelection, newSelection);
    }

    protected void handleSelect(SelectionEvent event) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            this.updateStructuredTextSelection(this.getSelection());
        }
    }

    public void internalRefresh(Object element) {
        if (element == null) {
            return;
        }
        Widget item = this.findItem(element);
        if (item != null) {
            this.internalRefresh(item, element, true);
        }
    }

    private void internalRefresh(Widget widget, Object element, boolean doStruct) {
        Object[] children;
        if (widget instanceof Item) {
            if (doStruct) {
                this.updatePlus((Item)widget, element);
            }
            this.updateItem(widget, element);
        }
        if (doStruct) {
            children = this.getSortedChildren(element);
            this.updateChildren(widget, element, children);
        }
        if ((children = this.getChildren(widget)) != null) {
            int i = 0;
            while (i < children.length) {
                Object item = children[i];
                Object data = item.getData();
                if (data != null) {
                    this.internalRefresh((Widget)item, data, doStruct);
                }
                ++i;
            }
        }
    }

    public synchronized void removeInvalidSelectionListener(ISelectionListener listener) {
        ISelectionListener[] newListeners = this.fInvalidSelectionListeners;
        if (this.fInvalidSelectionListeners != null && this.fInvalidSelectionListeners.length > 1) {
            ArrayList<ISelectionListener> oldListeners = new ArrayList<ISelectionListener>(Arrays.asList(this.fInvalidSelectionListeners));
            if (oldListeners.contains(listener)) {
                oldListeners.remove(listener);
                newListeners = oldListeners.toArray(new ISelectionListener[0]);
            }
        } else {
            newListeners = null;
        }
        this.fInvalidSelectionListeners = newListeners;
    }

    public void setCaretPosition(int caretPosition) {
        this.fCaretPosition = caretPosition;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (reveal) {
            this.updateStructuredTextSelection(selection);
        }
        super.setSelection(selection, reveal);
    }

    protected void updateStructuredTextSelection(ISelection selection) {
        StructuredTextSelectionChangedEvent event = new StructuredTextSelectionChangedEvent((ISelectionProvider)this, selection);
        this.fireSelectionChanged(event);
    }
}

