/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.util.Utilities;
import org.eclipse.wst.sse.ui.internal.CaretMediator;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.ViewerSelectionManager;
import org.eclipse.wst.sse.ui.internal.view.events.CaretEvent;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.ITextSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.eclipse.wst.sse.ui.internal.view.events.TextSelectionChangedEvent;

public class ViewerSelectionManagerImpl
implements ViewerSelectionManager {
    private CaretMediator fCaretMeditator;
    private int fCaretPosition = 0;
    protected IStructuredModel fModel;
    private boolean fModelChanging = false;
    private IDoubleClickListener[] fNodeDoubleClickListeners;
    private INodeSelectionListener[] fNodeSelectionListeners;
    private List fSelectedNodes;
    private int fTextSelectionEnd;
    private ITextSelectionListener[] fTextSelectionListeners;
    private int fTextSelectionStart;
    private ITextViewer fTextViewer;
    private InternalModelStateListener internalModelStateListener;
    private boolean isFiringNodeSelectionChanged = false;

    public ViewerSelectionManagerImpl() {
        this.internalModelStateListener = new InternalModelStateListener();
    }

    public ViewerSelectionManagerImpl(ITextViewer textViewer) {
        this.setTextViewer(textViewer);
        this.internalModelStateListener = new InternalModelStateListener();
    }

    public synchronized void addNodeDoubleClickListener(IDoubleClickListener listener) {
        if (listener == null) {
            Logger.log(2, "Likely error in ViewerSelectionManagerImpl::addNodeDoubleClickListener should not be called with null listener");
            return;
        }
        if (!Utilities.contains((Object[])this.fNodeDoubleClickListeners, (Object)listener)) {
            int oldSize = 0;
            if (this.fNodeDoubleClickListeners != null) {
                oldSize = this.fNodeDoubleClickListeners.length;
            }
            int newSize = oldSize + 1;
            IDoubleClickListener[] newListeners = new IDoubleClickListener[newSize];
            if (this.fNodeDoubleClickListeners != null) {
                System.arraycopy(this.fNodeDoubleClickListeners, 0, newListeners, 0, oldSize);
            }
            newListeners[newSize - 1] = listener;
            this.fNodeDoubleClickListeners = newListeners;
        }
    }

    public synchronized void addNodeSelectionListener(INodeSelectionListener listener) {
        if (listener == null) {
            Logger.log(2, "Likely error in ViewerSelectionManagerImpl::addNodeSelectionListener should not but called with null listener");
            return;
        }
        if (!Utilities.contains((Object[])this.fNodeSelectionListeners, (Object)listener)) {
            int oldSize = 0;
            if (this.fNodeSelectionListeners != null) {
                oldSize = this.fNodeSelectionListeners.length;
            }
            int newSize = oldSize + 1;
            INodeSelectionListener[] newListeners = new INodeSelectionListener[newSize];
            if (this.fNodeSelectionListeners != null) {
                System.arraycopy(this.fNodeSelectionListeners, 0, newListeners, 0, oldSize);
            }
            newListeners[newSize - 1] = listener;
            this.fNodeSelectionListeners = newListeners;
        }
    }

    public synchronized void addTextSelectionListener(ITextSelectionListener listener) {
        if (listener == null) {
            Logger.log(2, "Likely error in ViewerSelectionManagerImpl::addTextSelectionListener should not but called with null listener");
            return;
        }
        if (!Utilities.contains((Object[])this.fTextSelectionListeners, (Object)listener)) {
            int oldSize = 0;
            if (this.fTextSelectionListeners != null) {
                oldSize = this.fTextSelectionListeners.length;
            }
            int newSize = oldSize + 1;
            ITextSelectionListener[] newListeners = new ITextSelectionListener[newSize];
            if (this.fTextSelectionListeners != null) {
                System.arraycopy(this.fTextSelectionListeners, 0, newListeners, 0, oldSize);
            }
            newListeners[newSize - 1] = listener;
            this.fTextSelectionListeners = newListeners;
        }
    }

    public void caretMoved(CaretEvent event) {
        if (!this.isModelChanging()) {
            List selectedNodes = this.getTextWidgetSelectedNodes(event.getPosition());
            int caretPosition = event.getPosition();
            this.processSelectionChanged(event.getSource(), selectedNodes, caretPosition, caretPosition);
        }
    }

    protected void currentNodeChanged(Object source, List newSelectedNodes, int caretPosition) {
        this.fSelectedNodes = new Vector(newSelectedNodes);
        this.fCaretPosition = caretPosition;
        NodeSelectionChangedEvent nodeSelectionChangedEvent = new NodeSelectionChangedEvent(source, newSelectedNodes, caretPosition);
        this.fireNodeSelectionChangedEvent(nodeSelectionChangedEvent);
    }

    public void doubleClick(DoubleClickEvent event) {
        if (!this.isModelChanging()) {
            this.fireNodeDoubleClickEvent(event);
        }
    }

    protected void fireNodeDoubleClickEvent(final DoubleClickEvent event) {
        if (this.fNodeDoubleClickListeners != null && !this.isModelChanging()) {
            IDoubleClickListener[] holdListeners = this.fNodeDoubleClickListeners;
            int i = 0;
            while (i < holdListeners.length) {
                final IDoubleClickListener currentListener = holdListeners[i];
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        currentListener.doubleClick(event);
                    }
                });
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fireNodeSelectionChangedEvent(final NodeSelectionChangedEvent event) {
        if (this.fNodeSelectionListeners == null) return;
        if (this.isModelChanging()) return;
        this.isFiringNodeSelectionChanged = true;
        INodeSelectionListener[] holdListeners = this.fNodeSelectionListeners;
        try {
            int i = 0;
            while (i < holdListeners.length) {
                final INodeSelectionListener currentListener = holdListeners[i];
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        currentListener.nodeSelectionChanged(event);
                    }
                });
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.isFiringNodeSelectionChanged = false;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.isFiringNodeSelectionChanged = false;
            return;
        }
    }

    protected void fireTextSelectionChangedEvent(final TextSelectionChangedEvent event) {
        if (this.fTextSelectionListeners != null && !this.isModelChanging()) {
            ITextSelectionListener[] holdListeners = this.fTextSelectionListeners;
            int i = 0;
            while (i < holdListeners.length) {
                final ITextSelectionListener currentListener = holdListeners[i];
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        currentListener.textSelectionChanged(event);
                    }
                });
                ++i;
            }
        }
    }

    public int getCaretPosition() {
        return this.fCaretPosition;
    }

    public List getSelectedNodes() {
        return this.fSelectedNodes;
    }

    public ITextViewer getTextViewer() {
        return this.fTextViewer;
    }

    protected List getTextWidgetSelectedNodes(int offset) {
        if (this.fModel == null) {
            return new ArrayList(0);
        }
        IndexedRegion firstSelectedNode = this.fModel.getIndexedRegion(offset);
        ArrayList<IndexedRegion> selectedNodes = null;
        if (firstSelectedNode != null) {
            selectedNodes = new ArrayList<IndexedRegion>(1);
            selectedNodes.add(firstSelectedNode);
        } else {
            selectedNodes = new ArrayList(0);
        }
        return selectedNodes;
    }

    protected boolean isCurrentNodeChanged(List newSelectedNodes) {
        return !newSelectedNodes.equals(this.fSelectedNodes);
    }

    protected boolean isModelChanging() {
        return this.fModelChanging;
    }

    protected boolean isTextSelectionChanged(int textSelectionStart, int textSelectionEnd) {
        return this.fTextSelectionStart != textSelectionStart || this.fTextSelectionEnd != textSelectionEnd;
    }

    protected void processSelectionChanged(Object source, List selectedNodes, int selectionStart, int selectionEnd) {
        if (source == null) {
            Logger.log(4, "ViewerSelectionManager::processSelectionChanged. Unexpected null source");
        } else {
            if (this.isTextSelectionChanged(selectionStart, selectionEnd)) {
                this.textSelectionChanged(source, selectionStart, selectionEnd);
            }
            if (this.isCurrentNodeChanged(selectedNodes)) {
                this.currentNodeChanged(source, selectedNodes, selectionEnd);
            }
        }
    }

    public void release() {
        this.setTextViewer(null);
        if (this.fModel != null) {
            this.fModel.removeModelStateListener((IModelStateListener)this.internalModelStateListener);
        }
        this.fCaretMeditator.release();
    }

    public synchronized void removeNodeDoubleClickListener(IDoubleClickListener listener) {
        if (this.fNodeDoubleClickListeners != null && listener != null && Utilities.contains((Object[])this.fNodeDoubleClickListeners, (Object)listener)) {
            int oldSize = this.fNodeDoubleClickListeners.length;
            int newSize = oldSize - 1;
            IDoubleClickListener[] newListeners = new IDoubleClickListener[newSize];
            int index = 0;
            int i = 0;
            while (i < oldSize) {
                if (this.fNodeDoubleClickListeners[i] != listener) {
                    newListeners[index++] = this.fNodeDoubleClickListeners[i];
                }
                ++i;
            }
            this.fNodeDoubleClickListeners = newListeners;
        }
    }

    public synchronized void removeNodeSelectionListener(INodeSelectionListener listener) {
        if (this.fNodeSelectionListeners != null && listener != null && Utilities.contains((Object[])this.fNodeSelectionListeners, (Object)listener)) {
            int oldSize = this.fNodeSelectionListeners.length;
            int newSize = oldSize - 1;
            INodeSelectionListener[] newListeners = new INodeSelectionListener[newSize];
            int index = 0;
            int i = 0;
            while (i < oldSize) {
                if (this.fNodeSelectionListeners[i] != listener) {
                    newListeners[index++] = this.fNodeSelectionListeners[i];
                }
                ++i;
            }
            this.fNodeSelectionListeners = newListeners;
        }
    }

    public synchronized void removeTextSelectionListener(ITextSelectionListener listener) {
        if (this.fTextSelectionListeners != null && listener != null && Utilities.contains((Object[])this.fTextSelectionListeners, (Object)listener)) {
            int oldSize = this.fTextSelectionListeners.length;
            int newSize = oldSize - 1;
            ITextSelectionListener[] newListeners = new ITextSelectionListener[newSize];
            int index = 0;
            int i = 0;
            while (i < oldSize) {
                if (this.fTextSelectionListeners[i] != listener) {
                    newListeners[index++] = this.fTextSelectionListeners[i];
                }
                ++i;
            }
            this.fTextSelectionListeners = newListeners;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.isFiringNodeSelectionChanged || this.isModelChanging()) {
            return;
        }
        ISelection eventSelection = event.getSelection();
        if (eventSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)eventSelection;
            Vector<IndexedRegion> selectionNodes = selection.toList();
            Vector<IndexedRegion> selectNodes = null;
            int selectionStart = 0;
            int selectionEnd = 0;
            int l = selectionNodes.size();
            int i = 0;
            while (i < l) {
                Object o = selectionNodes.get(i);
                if (o instanceof IndexedRegion) {
                    IndexedRegion firstSelectedNode = (IndexedRegion)o;
                    selectionStart = firstSelectedNode.getStartOffset();
                    selectionEnd = firstSelectedNode.getEndOffset();
                    selectNodes = new Vector<IndexedRegion>(1);
                    selectNodes.add(firstSelectedNode);
                }
                ++i;
            }
            if (selectNodes == null) {
                selectNodes = selectionNodes;
            }
            this.processSelectionChanged(event.getSource(), selectNodes, selectionStart, selectionEnd);
        } else if (eventSelection instanceof ITextSelection) {
            ITextSelection selection = (ITextSelection)eventSelection;
            int selectionStart = selection.getOffset();
            this.setCaretPosition(selectionStart);
            int selectionEnd = selection.getOffset() + selection.getLength();
            List selectedNodes = this.getTextWidgetSelectedNodes(selection.getOffset());
            this.processSelectionChanged(event.getSource(), selectedNodes, selectionStart, selectionEnd);
        }
    }

    protected void setCaretPosition(int caretPosition) {
        this.fCaretPosition = caretPosition;
    }

    public void setModel(IStructuredModel newModel) {
        if (newModel != this.fModel) {
            if (this.fModel != null) {
                this.fModel.removeModelStateListener((IModelStateListener)this.internalModelStateListener);
            }
            this.fModel = newModel;
            if (this.fModel != null) {
                this.fModel.addModelStateListener((IModelStateListener)this.internalModelStateListener);
            }
        }
    }

    protected void setModelChanging(boolean modelChanging) {
        this.fModelChanging = modelChanging;
    }

    public void setTextViewer(ITextViewer newTextViewer) {
        StyledText textWidget;
        if (this.fCaretMeditator != null) {
            this.fCaretMeditator.removeCaretListener(this);
            this.fCaretMeditator.setTextWidget(null);
        }
        if (this.fTextViewer != null && (textWidget = this.fTextViewer.getTextWidget()) != null) {
            textWidget.removeSelectionListener((SelectionListener)this);
        }
        this.fTextViewer = newTextViewer;
        if (this.fTextViewer != null && (textWidget = this.fTextViewer.getTextWidget()) != null) {
            if (this.fCaretMeditator == null) {
                this.fCaretMeditator = new CaretMediator(textWidget);
            } else {
                this.fCaretMeditator.setTextWidget(textWidget);
            }
            this.fCaretMeditator.addCaretListener(this);
            textWidget.addSelectionListener((SelectionListener)this);
        }
    }

    protected void textSelectionChanged(Object source, int textSelectionStart, int textSelectionEnd) {
        this.fTextSelectionStart = textSelectionStart;
        this.fCaretPosition = this.fTextSelectionEnd = textSelectionEnd;
        TextSelectionChangedEvent textSelectionChangedEvent = new TextSelectionChangedEvent(source, this.fTextSelectionStart, this.fTextSelectionEnd);
        this.fireTextSelectionChangedEvent(textSelectionChangedEvent);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        if (!this.isModelChanging()) {
            List selectedNodes = this.getTextWidgetSelectedNodes(event.x);
            int selectionStart = event.x;
            int selectionEnd = event.y;
            this.processSelectionChanged(event.getSource(), selectedNodes, selectionStart, selectionEnd);
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (this.isFiringNodeSelectionChanged || this.isModelChanging()) {
            return;
        }
        this.widgetDefaultSelected(event);
    }

    class InternalModelStateListener
    implements IModelStateListener {
        InternalModelStateListener() {
        }

        public void modelAboutToBeChanged(IStructuredModel model) {
            ViewerSelectionManagerImpl.this.setModelChanging(true);
        }

        public void modelChanged(IStructuredModel model) {
            ViewerSelectionManagerImpl.this.setModelChanging(false);
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel originalmodel, IStructuredModel movedmodel) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        }

        public void modelReinitialized(IStructuredModel structuredModel) {
        }
    }
}

