/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.internal.graph.BreakCycles;
import org.eclipse.draw2d.internal.graph.GraphVisitor;
import org.eclipse.draw2d.internal.graph.HorizontalPlacement;
import org.eclipse.draw2d.internal.graph.InitialRankSolver;
import org.eclipse.draw2d.internal.graph.InvertEdges;
import org.eclipse.draw2d.internal.graph.LocalOptimizer;
import org.eclipse.draw2d.internal.graph.MinCross;
import org.eclipse.draw2d.internal.graph.PlaceEndpoints;
import org.eclipse.draw2d.internal.graph.PopulateRanks;
import org.eclipse.draw2d.internal.graph.RankAssigmentSolver;
import org.eclipse.draw2d.internal.graph.TightSpanningTreeSolver;
import org.eclipse.draw2d.internal.graph.VerticalPlacement;

public class DirectedGraphLayout
extends GraphVisitor {
    List steps = new ArrayList();

    public DirectedGraphLayout() {
        this.steps.add(new BreakCycles());
        this.steps.add(new InitialRankSolver());
        this.steps.add(new TightSpanningTreeSolver());
        this.steps.add(new RankAssigmentSolver());
        this.steps.add(new PopulateRanks());
        this.steps.add(new VerticalPlacement());
        this.steps.add(new MinCross());
        this.steps.add(new LocalOptimizer());
        this.steps.add(new HorizontalPlacement());
        this.steps.add(new PlaceEndpoints());
        this.steps.add(new InvertEdges());
    }

    public void visit(DirectedGraph graph) {
        GraphVisitor visitor;
        int i = 0;
        while (i < this.steps.size()) {
            visitor = (GraphVisitor)this.steps.get(i);
            visitor.visit(graph);
            ++i;
        }
        i = this.steps.size() - 1;
        while (i >= 0) {
            visitor = (GraphVisitor)this.steps.get(i);
            visitor.revisit(graph);
            --i;
        }
    }
}

