/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.annotations.registry;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.internal.annotations.core.AnnotationsCoreResources;
import org.eclipse.jst.common.internal.annotations.registry.AnnotationsControllerResources;
import org.eclipse.jst.common.internal.annotations.registry.TagSpec;

public class TagAttribSpec {
    private String attribName;
    private int flags;
    private String helpKey;
    private int type = 0;
    private static final int FLG_REQUIRED = 1;
    private String[] validValues;
    private TagSpec tagSpec;
    private Unique unique;

    public Unique getUnique() {
        return this.unique;
    }

    public boolean isUnique() {
        return this.unique != null;
    }

    public void setUnique() {
        this.unique = new Unique();
    }

    public void clearUnique() {
        this.unique = null;
    }

    public static int typeNameToType(String name) {
        if (name != null) {
            if (name.equalsIgnoreCase("text") || name.equalsIgnoreCase("string")) {
                return 0;
            }
            if (name.equalsIgnoreCase("boolean") || name.equalsIgnoreCase("bool")) {
                return 1;
            }
            if (name.equalsIgnoreCase("javaType")) {
                return 2;
            }
        }
        return 0;
    }

    public static String typeToTypeName(int ty) {
        switch (ty) {
            case 0: {
                return "string";
            }
            case 1: {
                return "bool";
            }
            case 2: {
                return "javaType";
            }
        }
        return "string";
    }

    public TagAttribSpec(String name) throws IllegalArgumentException {
        this(name, null);
    }

    public TagAttribSpec(String name, String hlpKey) {
        this.setAttribName(name);
        this.setHelpKey(hlpKey);
    }

    public void setType(int t) {
        this.type = t;
    }

    public void setType(String typename) {
        this.type = TagAttribSpec.typeNameToType(typename);
    }

    public int getType() {
        return this.type;
    }

    public boolean valueIsJavaType() {
        return this.type == 2;
    }

    public boolean valueIsText() {
        return this.type == 0;
    }

    public boolean valueIsBool() {
        return this.type == 1;
    }

    public String getAttribName() {
        return this.attribName;
    }

    public void setAttribName(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException(AnnotationsCoreResources.getString((String)"TagAttribSpec.6"));
        }
        this.attribName = name;
    }

    public boolean isRequired() {
        return (this.flags & 1) != 0;
    }

    public void setRequired() {
        this.flags |= 1;
    }

    public void clearRequired() {
        this.flags &= 0xFFFFFFFE;
    }

    public String getTextKey(int aType) {
        if (aType != 0) {
            return null;
        }
        if (this.helpKey == null) {
            this.helpKey = this.defaultHelpKey();
        }
        return this.helpKey;
    }

    public String transformLocalizedText(String txt) {
        if (txt == null) {
            return txt;
        }
        StringBuffer buf = new StringBuffer(txt.length() + 50);
        buf.append("<b>Type: ");
        buf.append(TagAttribSpec.typeToTypeName(this.type));
        buf.append(", Use: ");
        if (this.isRequired()) {
            buf.append("required");
        } else {
            buf.append("optional");
        }
        if (this.isUnique()) {
            buf.append(", unique:scope: ");
            buf.append(TagAttribSpec.uniqueScopeToString(this.getUnique().getScope()));
        }
        buf.append("</b><p>");
        buf.append(txt);
        buf.append("</p>");
        return buf.toString();
    }

    public String getHelpKey() {
        return this.getTextKey(0);
    }

    public void setHelpKey(String key) {
        this.helpKey = key;
    }

    private String defaultHelpKey() {
        return "ath." + this.attribName;
    }

    public static int uniqueScopeFromString(String scopeStr) {
        if (scopeStr != null) {
            if (scopeStr.equalsIgnoreCase("module")) {
                return 0;
            }
            if (scopeStr.equalsIgnoreCase("file")) {
                return 1;
            }
            if (scopeStr.equalsIgnoreCase("type")) {
                return 2;
            }
            if (scopeStr.equalsIgnoreCase("method")) {
                return 3;
            }
            if (scopeStr.equalsIgnoreCase("field")) {
                return 4;
            }
        }
        Logger.getLogger().logError(String.valueOf(AnnotationsControllerResources.getString("TagAttribSpec.1")) + scopeStr);
        return 0;
    }

    public static String uniqueScopeToString(int scope) {
        switch (scope) {
            case 0: {
                return "module";
            }
            case 1: {
                return "file";
            }
            case 2: {
                return "type";
            }
            case 3: {
                return "method";
            }
            case 4: {
                return "field";
            }
        }
        Logger.getLogger().logError(String.valueOf(AnnotationsControllerResources.getString("TagAttribSpec.1")) + scope);
        return "unknown value";
    }

    public String[] getValidValues() {
        return this.validValues;
    }

    public void setValidValues(String[] validValues) {
        this.validValues = validValues;
    }

    public TagSpec getTagSpec() {
        return this.tagSpec;
    }

    void setTagSpec(TagSpec tagSpec) {
        this.tagSpec = tagSpec;
    }

    public String lookupTagHelp() throws MissingResourceException {
        ResourceBundle b = this.getTagSpec().getResourceBundle();
        if (b == null) {
            return null;
        }
        String key = this.getHelpKey();
        String val = b.getString(this.getHelpKey());
        if (val == key) {
            val = null;
        }
        return this.transformLocalizedText(val);
    }

    public static interface Type {
        public static final int TEXT = 0;
        public static final int BOOLEAN = 1;
        public static final int JAVATYPE = 2;
        public static final int ENUM = 3;
    }

    public class Unique {
        public static final int MODULE = 0;
        public static final int FILE = 1;
        public static final int TYPE = 2;
        public static final int METHOD = 3;
        public static final int FIELD = 4;
        private int scope = 0;

        public int getScope() {
            return this.scope;
        }

        public void setScope(int in) {
            this.scope = in;
        }
    }
}

