/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.extension;

import org.eclipse.jst.ws.internal.consumption.command.common.AddModuleToServerCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateServerCommand;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.ws.internal.provisional.wsrt.IWebService;

public class PreServiceInstallCommand
extends SimpleCommand {
    private IWebService webService_;
    private String project_;
    private String module_;
    private String earProject_;
    private String ear_;

    public Status execute(Environment environment) {
        System.out.println("In Pre service install command.");
        if (this.webService_.getWebServiceInfo().getServerInstanceId() == null) {
            CreateServerCommand createServerCommand = new CreateServerCommand();
            createServerCommand.setServerFactoryid(this.webService_.getWebServiceInfo().getServerFactoryId());
            Status createServerStatus = createServerCommand.execute(environment);
            if (createServerStatus.getSeverity() == 0) {
                this.webService_.getWebServiceInfo().setServerInstanceId(createServerCommand.getServerInstanceId());
            } else {
                if (createServerStatus.getSeverity() == 4) {
                    environment.getStatusHandler().reportError(createServerStatus);
                }
                return createServerStatus;
            }
        }
        AddModuleToServerCommand command = new AddModuleToServerCommand();
        command.setServerInstanceId(this.webService_.getWebServiceInfo().getServerInstanceId());
        if (this.earProject_ != null && this.earProject_.length() > 0 && this.ear_ != null && this.ear_.length() > 0) {
            command.setProject(this.earProject_);
            command.setModule(this.ear_);
        } else {
            command.setProject(this.project_);
            command.setModule(this.module_);
        }
        Status status = command.execute(environment);
        if (status.getSeverity() == 4) {
            environment.getStatusHandler().reportError(status);
        }
        return status;
    }

    public void setProject(String project) {
        this.project_ = project;
    }

    public void setModule(String module) {
        this.module_ = module;
    }

    public void setEarProject(String earProject) {
        this.earProject_ = earProject;
    }

    public void setEar(String ear) {
        this.ear_ = ear;
    }

    public void setWebService(IWebService webService) {
        this.webService_ = webService;
    }
}

