/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.task;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;

public class MoveJavaFilesTask
extends SimpleCommand {
    private final String LABEL = "TASK_LABEL_MOVE_JAVA_FILES";
    private final String DESCRIPTION = "TASK_DESC_MOVE_JAVA_FILES";
    private JavaWSDLParameter javaWSDLParam_;
    private MessageUtils msgUtils_;
    private MessageUtils coreMsgUtils_;
    private IProject serviceProject_;
    private String moduleName_;

    public MoveJavaFilesTask(String moduleName) {
        String pluginId = "org.eclipse.jst.ws.axis.creation.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.coreMsgUtils_ = new MessageUtils("org.eclipse.jst.ws.axis.consumption.core.consumption", (Object)this);
        this.setDescription(this.msgUtils_.getMessage("TASK_DESC_MOVE_JAVA_FILES"));
        this.setName(this.msgUtils_.getMessage("TASK_LABEL_MOVE_JAVA_FILES"));
        this.moduleName_ = moduleName;
    }

    public MoveJavaFilesTask() {
        String pluginId = "org.eclipse.jst.ws.axis.creation.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.coreMsgUtils_ = new MessageUtils("org.eclipse.jst.ws.axis.consumption.core.consumption", (Object)this);
        this.setDescription(this.msgUtils_.getMessage("TASK_DESC_MOVE_JAVA_FILES"));
        this.setName(this.msgUtils_.getMessage("TASK_LABEL_MOVE_JAVA_FILES"));
    }

    public MoveJavaFilesTask(JavaWSDLParameter javaWSDLParam) {
        String pluginId = "org.eclipse.jst.ws.axis.creation.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.coreMsgUtils_ = new MessageUtils("org.eclipse.jst.ws.axis.consumption.core.consumption", (Object)this);
        this.setDescription(this.msgUtils_.getMessage("TASK_DESC_MOVE_JAVA_FILES"));
        this.setName(this.msgUtils_.getMessage("TASK_LABEL_MOVE_JAVA_FILES"));
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        if (this.javaWSDLParam_ == null) {
            status = new SimpleStatus("", this.coreMsgUtils_.getMessage("MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET"), 4);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        IProject project = this.serviceProject_;
        String projectURL = ServerUtils.getEncodedWebComponentURL((IProject)project, (String)this.moduleName_);
        if (projectURL == null) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_PROJECT_URL", (Object[])new String[]{project.toString()}), 4);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        this.javaWSDLParam_.setProjectURL(projectURL);
        String[] javaFiles = this.javaWSDLParam_.getJavaFiles();
        String javaoutput = this.javaWSDLParam_.getJavaOutput();
        String output = this.javaWSDLParam_.getOutput();
        if (javaFiles == null || javaoutput == null && output == null) {
            return status;
        }
        try {
            int i = 0;
            while (i < javaFiles.length) {
                String resourceToMove = javaFiles[i].substring(output.length());
                String targetFileName = String.valueOf(javaoutput) + resourceToMove;
                new File(targetFileName);
                File source = new File(javaFiles[i]);
                source.delete();
                ++i;
            }
        }
        catch (Exception e) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_MOVE_RESOURCE", (Object[])new String[]{e.getLocalizedMessage()}), 4, (Throwable)e);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        return status;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject_ = serviceProject;
    }
}

