/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal.workingsets;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ComponentWorkingSetDescriptor {
    private IConfigurationElement configElement;
    public static final String ATT_ID = "id";
    public static final String ATT_LABEL = "label";
    public static final String ATT_ICON = "icon";
    public static final String ATT_MODULE_TYPE = "typeId";
    private String id;
    private String label;
    private String icon;
    private String typeId;

    public ComponentWorkingSetDescriptor(IConfigurationElement aConfigElement) throws WorkbenchException {
        this.configElement = aConfigElement;
        this.init();
    }

    void init() throws WorkbenchException {
        this.label = this.configElement.getAttribute(ATT_LABEL);
        this.id = this.configElement.getAttribute(ATT_ID);
        this.typeId = this.configElement.getAttribute(ATT_MODULE_TYPE);
        this.icon = this.configElement.getAttribute(ATT_ICON);
        if (this.id == null || this.id.length() == 0) {
            throw new WorkbenchException("Missing attribute: id in common working set extension: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
        if (this.label == null || this.label.length() == 0) {
            throw new WorkbenchException("Missing attribute: label in common working set extension: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
        if (this.typeId == null || this.typeId.length() == 0) {
            throw new WorkbenchException("Missing attribute: typeId in common working set extension: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public ImageDescriptor getIcon() {
        if (this.icon == null) {
            return null;
        }
        IExtension extension = this.configElement.getDeclaringExtension();
        String extendingPluginId = extension.getNamespace();
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)extendingPluginId, (String)this.icon);
    }
}

