/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.workingset.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jst.common.navigator.internal.workingset.views.CustomHashtable;
import org.eclipse.jst.common.navigator.internal.workingset.views.TreePath;

public class MultiElementSelection
extends StructuredSelection {
    private static final TreePath[] EMPTY_TREE_PATHS = new TreePath[0];
    private TreePath[] fAllTreePaths;
    private CustomHashtable fElement2TreePaths;

    public MultiElementSelection(StructuredViewer viewer, List elements, TreePath[] paths) {
        super(elements);
        this.fAllTreePaths = paths;
        this.fElement2TreePaths = this.createTreePathMap(viewer.getComparer());
    }

    public TreePath[] getAllTreePaths() {
        return this.fAllTreePaths;
    }

    public TreePath[] getTreePaths(Object element) {
        Object value = this.fElement2TreePaths.get(element);
        if (value == null) {
            return EMPTY_TREE_PATHS;
        }
        if (value instanceof TreePath) {
            return new TreePath[]{(TreePath)value};
        }
        if (value instanceof List) {
            List l = (List)value;
            return l.toArray(new TreePath[l.size()]);
        }
        Assert.isTrue((boolean)false, (String)"Should not happen");
        return null;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().getName().equals(o.getClass().getName())) {
            return false;
        }
        MultiElementSelection otherSelection = (MultiElementSelection)((Object)o);
        if (this.fAllTreePaths.length != otherSelection.fAllTreePaths.length) {
            return false;
        }
        int i = 0;
        while (i < this.fAllTreePaths.length) {
            if (!this.fAllTreePaths[i].equals(otherSelection.fAllTreePaths[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private CustomHashtable createTreePathMap(IElementComparer comparer) {
        CustomHashtable result = new CustomHashtable(comparer);
        int i = 0;
        while (i < this.fAllTreePaths.length) {
            TreePath path = this.fAllTreePaths[i];
            Object key = path.getLastSegment();
            if (key != null) {
                Object value = result.get(key);
                if (value == null) {
                    result.put(key, path);
                } else if (value instanceof TreePath) {
                    ArrayList<Object> l = new ArrayList<Object>();
                    l.add(value);
                    l.add(path);
                    result.put(key, l);
                } else if (value instanceof List) {
                    ((List)value).add(path);
                } else {
                    Assert.isTrue((boolean)false, (String)"Should not happen");
                }
            }
            ++i;
        }
        return result;
    }
}

