/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.swt.widgets.Control;

public class DelegateShowProjectContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    protected static final int ORIGINAL = 0;
    protected static final int PARENT = 1;
    protected static final int GRANT_PARENT = 2;
    protected static final int PROJECT = 4;
    protected static final Object[] NO_CHILDREN = new Object[0];
    TreeViewer fViewer;
    private Object fInput;
    private int fPendingChanges;

    protected Object getViewerInput() {
        return this.fInput;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (this.inputDeleted()) {
                return;
            }
            this.processDelta(event.getDelta());
        }
        catch (JavaModelException e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    private boolean inputDeleted() {
        if (this.fInput == null) {
            return false;
        }
        if (this.fInput instanceof IResource && ((IResource)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof WorkingSetModel) {
            return false;
        }
        this.postRefresh(this.fInput, 0, this.fInput);
        return true;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = NO_CHILDREN;
        if (parentElement instanceof IWorkspaceRoot) {
            children = ((IWorkspaceRoot)parentElement).getProjects();
        }
        return children;
    }

    public Object getParent(Object child) {
        return this.internalGetParent(child);
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
        if (oldInput == null && newInput != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        } else if (oldInput != null && newInput == null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        this.fInput = newInput;
    }

    private void processDelta(IResourceDelta delta) throws JavaModelException {
        IResourceDelta[] resourceDeltas;
        IProject proj;
        if (delta == null) {
            return;
        }
        int kind = delta.getKind();
        int flags = delta.getFlags();
        IResource resource = delta.getResource();
        int resourceType = resource.getType();
        if (!(resourceType == 8 || resourceType == 4 || (proj = resource.getProject()) != null && proj.getProject().isOpen())) {
            return;
        }
        if (resourceType == 4 && (flags & 0x4000) != 0) {
            this.postRefresh(resource, 0, resource);
            return;
        }
        if (kind == 2) {
            this.postRemove(resource);
            return;
        }
        if (kind == 1) {
            Object parent = this.internalGetParent(resource);
            this.postAdd(parent, resource);
        }
        if (this.processResourceDeltas(resourceDeltas = delta.getAffectedChildren(), resource)) {
            return;
        }
    }

    private boolean processResourceDeltas(IResourceDelta[] deltas, Object parent) {
        if (deltas == null) {
            return false;
        }
        if (deltas.length > 1) {
            this.postRefresh(parent, 0, parent);
            return true;
        }
        int i = 0;
        while (i < deltas.length) {
            if (this.processResourceDelta(deltas[i], parent)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean processResourceDelta(IResourceDelta delta, Object parent) {
        int status = delta.getKind();
        int flags = delta.getFlags();
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        if ((status & 2) != 0) {
            this.postRemove(resource);
        }
        if ((status & 1) != 0) {
            this.postAdd(parent, resource);
        }
        if ((flags & 0x4000) != 0) {
            this.postProjectStateChanged(this.internalGetParent(parent));
            return true;
        }
        this.processResourceDeltas(delta.getAffectedChildren(), resource);
        return false;
    }

    private void postRefresh(Object root, int relation, Object affectedElement) {
        if (this.isParent(root, this.fInput)) {
            root = this.fInput;
        }
        ArrayList<Object> toRefresh = new ArrayList<Object>(1);
        toRefresh.add(root);
        this.augmentElementToRefresh(toRefresh, relation, affectedElement);
        this.postRefresh(toRefresh, true);
    }

    protected void augmentElementToRefresh(List toRefresh, int relation, Object affectedElement) {
    }

    boolean isParent(Object root, Object child) {
        Object parent = this.getParent(child);
        if (parent == null) {
            return false;
        }
        if (parent.equals(root)) {
            return true;
        }
        return this.isParent(root, parent);
    }

    void postRefresh(final List toRefresh, final boolean updateLabels) {
        this.postRunnable(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Control ctrl = DelegateShowProjectContentProvider.this.fViewer.getControl();
                if (ctrl == null) return;
                if (ctrl.isDisposed()) return;
                try {
                    DelegateShowProjectContentProvider.this.fViewer.getControl().setRedraw(false);
                    Iterator iter = toRefresh.iterator();
                    while (iter.hasNext()) {
                        Object next = iter.next();
                        DelegateShowProjectContentProvider.this.fViewer.refresh(next, updateLabels);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    DelegateShowProjectContentProvider.this.fViewer.getControl().setRedraw(true);
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                DelegateShowProjectContentProvider.this.fViewer.getControl().setRedraw(true);
            }
        });
    }

    private void postAdd(final Object parent, final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = DelegateShowProjectContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed() && DelegateShowProjectContentProvider.this.fViewer.testFindItem(element) == null) {
                    DelegateShowProjectContentProvider.this.fViewer.add(parent, element);
                }
            }
        });
    }

    private void postRemove(final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = DelegateShowProjectContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    DelegateShowProjectContentProvider.this.fViewer.remove(element);
                }
            }
        });
    }

    private void postProjectStateChanged(final Object root) {
        this.postRunnable(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Control ctrl = DelegateShowProjectContentProvider.this.fViewer.getControl();
                if (ctrl == null) return;
                if (ctrl.isDisposed()) return;
                try {
                    DelegateShowProjectContentProvider.this.fViewer.getControl().setRedraw(false);
                    DelegateShowProjectContentProvider.this.fViewer.refresh(root, true);
                    DelegateShowProjectContentProvider.this.fViewer.setSelection(DelegateShowProjectContentProvider.this.fViewer.getSelection());
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    DelegateShowProjectContentProvider.this.fViewer.getControl().setRedraw(true);
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                DelegateShowProjectContentProvider.this.fViewer.getControl().setRedraw(true);
            }
        });
    }

    void postRunnable(final Runnable r) {
        Control ctrl = this.fViewer.getControl();
        Runnable trackedRunnable = new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    r.run();
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    DelegateShowProjectContentProvider.this.removePendingChange();
                    throw throwable;
                }
                {
                    Object var1_3 = null;
                    DelegateShowProjectContentProvider.this.removePendingChange();
                    return;
                }
            }
        };
        if (ctrl != null && !ctrl.isDisposed()) {
            this.addPendingChange();
            try {
                ctrl.getDisplay().asyncExec(trackedRunnable);
            }
            catch (RuntimeException e) {
                this.removePendingChange();
                throw e;
            }
            catch (Error e) {
                this.removePendingChange();
                throw e;
            }
        }
    }

    public synchronized boolean hasPendingChanges() {
        return this.fPendingChanges > 0;
    }

    private synchronized void addPendingChange() {
        ++this.fPendingChanges;
    }

    synchronized void removePendingChange() {
        --this.fPendingChanges;
        if (this.fPendingChanges < 0) {
            this.fPendingChanges = 0;
        }
    }

    public boolean hasChildren(Object element) {
        return element instanceof IWorkspaceRoot;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }
}

