/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.ViewActionGroup;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetActionGroup;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.providers.WorkingSetAwareContentProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorRegistry;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentProvider;

public class WorkingSetActionProvider
implements ICommonActionProvider,
IPropertyChangeListener {
    private ViewActionGroup viewActionGroup;
    private WorkingSetActionGroup workingSetActionGroup;
    private WorkingSetAwareContentProvider contentProvider;
    private NavigatorContentService contentService;
    private boolean hasFilledActionBars;
    private StructuredViewer viewer;

    public void init(IViewPart aViewPart, StructuredViewer aViewer, NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.viewer = aViewer;
        this.viewActionGroup = new ViewActionGroup(2, this, aViewPart.getSite().getShell());
        this.workingSetActionGroup = new WorkingSetActionGroup(aViewPart);
        this.viewActionGroup.setWorkingSetModel(this.getContentProvider().getWorkingSetModel());
        this.viewActionGroup.fillFilters(this.viewer);
    }

    public void dispose() {
        this.viewActionGroup.dispose();
        this.workingSetActionGroup.dispose();
    }

    public void setActionContext(ActionContext aContext) {
        this.viewActionGroup.setContext(aContext);
        this.workingSetActionGroup.setContext(aContext);
    }

    public boolean fillContextMenu(IMenuManager aMenu) {
        this.viewActionGroup.fillContextMenu(aMenu);
        this.workingSetActionGroup.fillContextMenu(aMenu);
        return true;
    }

    public boolean fillActionBars(IActionBars theActionBars) {
        if (!this.hasFilledActionBars) {
            this.viewActionGroup.fillActionBars(theActionBars);
            this.workingSetActionGroup.fillActionBars(theActionBars);
            this.hasFilledActionBars = true;
            return true;
        }
        return false;
    }

    public void restoreState(IMemento aMemento) {
        this.getContentProvider().restoreState(aMemento);
        this.viewActionGroup.restoreState(aMemento);
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    public void saveState(IMemento aMemento) {
        this.getContentProvider().saveState(aMemento);
        this.viewActionGroup.saveState(aMemento);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.getContentProvider().workingSetModelChanged(event);
        if (ViewActionGroup.MODE_CHANGED.equals(event.getProperty())) {
            this.viewActionGroup.fillFilters(this.viewer);
        }
    }

    private WorkingSetAwareContentProvider getContentProvider() {
        NavigatorContentDescriptor groupDescriptor;
        if (this.contentProvider == null && (groupDescriptor = NavigatorContentDescriptorRegistry.getInstance().getContentDescriptor("org.eclipse.wst.common.navigator.workingsets")) != null) {
            NavigatorContentProvider delegateContentProvider = (NavigatorContentProvider)this.contentService.getDescriptorInstance(groupDescriptor).getContentProvider();
            this.contentProvider = (WorkingSetAwareContentProvider)delegateContentProvider.getDelegateContentProvider();
        }
        return this.contentProvider;
    }
}

