/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.IWorkingSetActionGroup;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.ViewAction;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetShowActionGroup;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionGroup;

public class ViewActionGroup
extends ActionGroup {
    public static final int SHOW_PROJECTS = 1;
    public static final int SHOW_WORKING_SETS = 2;
    public static final String MODE_CHANGED;
    static final String TAG_ROOT_MODE = "viewActionMode";
    private static final Integer INT_SHOW_PROJECTS;
    private static final Integer INT_SHOW_WORKING_SETS;
    private IPropertyChangeListener fChangeListener;
    private ViewAction projects;
    private ViewAction workingSets;
    private int fMode;
    private IMenuManager fMenuManager;
    private IWorkingSetActionGroup fActiveActionGroup;
    private WorkingSetShowActionGroup fShowActionGroup;
    private WorkingSetFilterActionGroup fFilterActionGroup;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.common.navigator.internal.ui.workingsets.ViewActionGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MODE_CHANGED = String.valueOf(clazz.getName()) + ".mode_changed";
        INT_SHOW_PROJECTS = new Integer(1);
        INT_SHOW_WORKING_SETS = new Integer(2);
    }

    public ViewActionGroup(int mode, IPropertyChangeListener changeListener, Shell shell) {
        this.fChangeListener = changeListener;
        this.fFilterActionGroup = new WorkingSetFilterActionGroup(shell, changeListener);
        this.fShowActionGroup = new WorkingSetShowActionGroup(shell);
        this.fMode = mode;
        this.fActiveActionGroup = this.showWorkingSets() ? this.fShowActionGroup : this.fFilterActionGroup;
    }

    public void dispose() {
        this.fFilterActionGroup.dispose();
        this.fShowActionGroup.dispose();
        this.fChangeListener = null;
        super.dispose();
    }

    public void setWorkingSetModel(WorkingSetModel model) {
        this.fShowActionGroup.setWorkingSetMode(model);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.fMenuManager = actionBars.getMenuManager();
        MenuManager showMenu = new MenuManager(WorkingSetMessages.getString("ViewActionGroup.show.label"));
        this.fillShowMenu((IMenuManager)showMenu);
        this.fMenuManager.add((IContributionItem)showMenu);
        this.fMenuManager.add((IContributionItem)new Separator("working_set_action_group"));
        if (this.fActiveActionGroup == null) {
            this.fActiveActionGroup = this.fFilterActionGroup;
        }
        ((ActionGroup)this.fActiveActionGroup).fillActionBars(actionBars);
    }

    private void fillShowMenu(IMenuManager menu) {
        this.projects = new ViewAction(this, 1);
        this.projects.setText(WorkingSetMessages.getString("ViewActionGroup.projects.label"));
        menu.add((IAction)this.projects);
        this.workingSets = new ViewAction(this, 2);
        this.workingSets.setText(WorkingSetMessages.getString("ViewActionGroup.workingSets.label"));
        menu.add((IAction)this.workingSets);
        if (this.fMode == 1) {
            this.projects.setChecked(true);
        } else {
            this.workingSets.setChecked(true);
        }
    }

    public void fillFilters(StructuredViewer viewer) {
        ViewerFilter workingSetFilter = this.fFilterActionGroup.getWorkingSetFilter();
        if (this.showProjects()) {
            viewer.addFilter(workingSetFilter);
        } else if (this.showWorkingSets()) {
            viewer.removeFilter(workingSetFilter);
        }
    }

    public void setMode(int mode) {
        PropertyChangeEvent event;
        this.fMode = mode;
        this.fActiveActionGroup.cleanViewMenu(this.fMenuManager);
        if (mode == 1) {
            this.fActiveActionGroup = this.fFilterActionGroup;
            event = new PropertyChangeEvent((Object)this, MODE_CHANGED, (Object)INT_SHOW_WORKING_SETS, (Object)INT_SHOW_PROJECTS);
        } else {
            this.fActiveActionGroup = this.fShowActionGroup;
            event = new PropertyChangeEvent((Object)this, MODE_CHANGED, (Object)INT_SHOW_PROJECTS, (Object)INT_SHOW_WORKING_SETS);
        }
        this.fActiveActionGroup.fillViewMenu(this.fMenuManager);
        if (this.fMenuManager != null) {
            this.fMenuManager.updateAll(true);
        }
        this.fChangeListener.propertyChange(event);
    }

    public WorkingSetFilterActionGroup getFilterGroup() {
        return this.fFilterActionGroup;
    }

    public void restoreState(IMemento memento) {
        this.fFilterActionGroup.restoreState(memento);
        this.restoreRootMode(memento);
        this.setMode(this.fMode);
        if (this.fMode == 1 && this.projects != null && this.workingSets != null) {
            this.projects.setChecked(true);
            this.workingSets.setChecked(false);
        } else {
            this.workingSets.setChecked(true);
            this.projects.setChecked(false);
        }
    }

    public void saveState(IMemento memento) {
        this.fFilterActionGroup.saveState(memento);
        memento.putInteger(TAG_ROOT_MODE, this.fMode);
    }

    private boolean showProjects() {
        return this.fMode == 1;
    }

    private boolean showWorkingSets() {
        return this.fMode == 2;
    }

    private void restoreRootMode(IMemento memento) {
        if (memento != null) {
            Integer value = memento.getInteger(TAG_ROOT_MODE);
            int n = this.fMode = value == null ? 1 : value;
            if (this.fMode != 1 && this.fMode != 2) {
                this.fMode = 1;
            }
        } else {
            this.fMode = 1;
        }
    }
}

