/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.AbstractWorkingSetManager;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.CommonWorkingSetProviderRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class CommonWorkingSetManager
extends AbstractWorkingSetManager {
    private static final CommonWorkingSetProviderRegistry COMMON_WORKING_SET_PROVIDER_REGISTRY = CommonWorkingSetProviderRegistry.getInstance();
    private static final String WORKING_SET_STATE_FILENAME = "commonworkingsets.xml";
    private ListenerList propertyChangeListeners = new ListenerList();

    public CommonWorkingSetManager(BundleContext context) {
        super(context);
        this.init();
    }

    public void addRecentWorkingSet(IWorkingSet workingSet) {
        this.internalAddRecentWorkingSet(workingSet);
        this.saveState();
    }

    public void addWorkingSet(IWorkingSet workingSet) {
        super.addWorkingSet(workingSet);
        this.saveState();
    }

    private File getWorkingSetStateFile() {
        IPath path = WorkbenchPlugin.getDefault().getDataLocation();
        if (path == null) {
            return null;
        }
        path = path.append(WORKING_SET_STATE_FILENAME);
        return path.toFile();
    }

    public void removeWorkingSet(IWorkingSet workingSet) {
        if (this.internalRemoveWorkingSet(workingSet)) {
            this.saveState();
        }
    }

    public void restoreState() {
        File stateFile = this.getWorkingSetStateFile();
        if (stateFile != null && stateFile.exists()) {
            try {
                FileInputStream input = new FileInputStream(stateFile);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)input, "utf-8"));
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                this.restoreWorkingSetState((IMemento)memento);
                this.restoreMruList((IMemento)memento);
                reader.close();
            }
            catch (IOException iOException) {
                MessageDialog.openError(null, (String)WorkbenchMessages.ProblemRestoringWorkingSetState_title, (String)WorkbenchMessages.ProblemRestoringWorkingSetState_message);
            }
            catch (WorkbenchException e) {
                ErrorDialog.openError(null, (String)WorkbenchMessages.ProblemRestoringWorkingSetState_title, (String)WorkbenchMessages.ProblemRestoringWorkingSetState_message, (IStatus)e.getStatus());
            }
        }
    }

    private void saveState() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"workingSetManager");
        File stateFile = this.getWorkingSetStateFile();
        if (stateFile == null) {
            return;
        }
        this.saveWorkingSetState((IMemento)memento);
        this.saveMruList((IMemento)memento);
        try {
            FileOutputStream stream = new FileOutputStream(stateFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
            memento.save((Writer)writer);
            writer.close();
        }
        catch (IOException iOException) {
            stateFile.delete();
            MessageDialog.openError(null, (String)WorkbenchMessages.ProblemSavingWorkingSetState_title, (String)WorkbenchMessages.ProblemSavingWorkingSetState_message);
        }
    }

    public void workingSetChanged(IWorkingSet changedWorkingSet, String propertyChangeId, Object oldValue) {
        this.saveState();
        super.workingSetChanged(changedWorkingSet, propertyChangeId, oldValue);
    }

    private void init() {
        this.addCommonWorkingSets();
    }

    private void addCommonWorkingSets() {
        IWorkingSet[] workingSets = COMMON_WORKING_SET_PROVIDER_REGISTRY.getAllWorkingSets();
        IWorkingSet workingSet = null;
        int x = 0;
        while (x < workingSets.length) {
            workingSet = workingSets[x];
            this.addWorkingSet(workingSet);
            ++x;
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove((Object)listener);
    }

    protected void firePropertyChange(String changeId, Object oldValue, Object newValue) {
        final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, changeId, oldValue, newValue);
        new UIJob("Updating Property Change Listeners"){

            public IStatus runInUIThread(IProgressMonitor aMonitor) {
                Object[] listeners = CommonWorkingSetManager.this.propertyChangeListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    ((IPropertyChangeListener)listeners[i]).propertyChange(event);
                    ++i;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

