/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jst.common.navigator.internal.actions.CompressedMenu;
import org.eclipse.jst.common.navigator.internal.actions.NavigateActionGroup;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.NewExampleAction;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardRegistry;
import org.eclipse.wst.common.navigator.internal.actions.CommonWizardRegistry;
import org.eclipse.wst.common.navigator.internal.actions.WizardActionGroup;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.actions.CommonActionProvider;

public class OpenActionsExtension
extends CommonActionProvider
implements ICommonActionProvider {
    public static final String OPEN_WITH_ID = String.valueOf(WorkbenchNavigatorPlugin.PLUGIN_ID) + ".OpenWithSubMenu";
    public static final String COMMON_NAVIGATOR_NEW_MENU = "common.new.menu";
    private static final String FULL_EXAMPLES_WIZARD_CATEGORY = "org.eclipse.ui.Examples";
    private static final CommonWizardRegistry COMMON_WIZARD_REGISTRY = CommonWizardRegistry.getInstance();
    private NavigateActionGroup openActionGroup;
    private IAction showDlgAction;
    private IAction newProjectAction;
    private IAction newExampleAction;
    private ActionContext actionContext;
    private WizardActionGroup newWizardActionGroup;

    public void init(IViewPart aViewPart, StructuredViewer aViewer, NavigatorContentService aContentService) {
        this.openActionGroup = new NavigateActionGroup(aViewPart);
        IWorkbenchWindow window = aViewPart.getViewSite().getWorkbenchWindow();
        this.showDlgAction = ActionFactory.NEW.create(window);
        this.newProjectAction = new NewProjectAction(window);
        this.newExampleAction = new NewExampleAction(window);
        this.newWizardActionGroup = new WizardActionGroup(window, "newWizards");
    }

    public void dispose() {
        this.openActionGroup.dispose();
    }

    public void setActionContext(ActionContext aContext) {
        this.actionContext = aContext;
        this.openActionGroup.setContext(aContext);
    }

    public boolean fillContextMenu(IMenuManager aMenu) {
        this.openActionGroup.fillContextMenu(aMenu);
        this.addNewMenu(aMenu);
        return true;
    }

    public boolean fillActionBars(IActionBars theActionBars) {
        this.openActionGroup.fillActionBars(theActionBars);
        return true;
    }

    private void addNewMenu(IMenuManager menuManager) {
        CompressedMenu submenu = new CompressedMenu(IDEWorkbenchMessages.Workbench_new, COMMON_NAVIGATOR_NEW_MENU);
        submenu.add(this.newProjectAction);
        submenu.add((IContributionItem)new Separator());
        this.fillNewMenu((IMenuManager)submenu);
        submenu.add((IContributionItem)new Separator("additions"));
        if (this.hasExamples()) {
            submenu.add((IContributionItem)new Separator());
            submenu.add(this.newExampleAction);
        }
        submenu.add((IContributionItem)new Separator());
        submenu.add(this.showDlgAction);
        menuManager.insertAfter("group.new", (IContributionItem)submenu);
    }

    private boolean hasExamples() {
        IWizardRegistry newRegistry = WorkbenchPlugin.getDefault().getNewWizardRegistry();
        IWizardCategory category = newRegistry.findCategory(FULL_EXAMPLES_WIZARD_CATEGORY);
        return category != null;
    }

    private void fillNewMenu(IMenuManager aSubmenu) {
        IStructuredSelection structuredSelection;
        if (this.actionContext != null && !this.actionContext.getSelection().isEmpty() && this.actionContext.getSelection() instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)this.actionContext.getSelection()).size() == 1) {
            this.addCommomWizardNewMenus(aSubmenu, structuredSelection.getFirstElement());
        }
    }

    private void addCommomWizardNewMenus(IMenuManager aSubmenu, Object anElement) {
        String[] wizardDescriptorIds = COMMON_WIZARD_REGISTRY.getEnabledCommonWizardDescriptorIds(anElement, "new");
        if (wizardDescriptorIds.length == 0) {
            return;
        }
        this.newWizardActionGroup.setWizardActionIds(wizardDescriptorIds);
        this.newWizardActionGroup.setContext(this.actionContext);
        this.newWizardActionGroup.fillContextMenu(aSubmenu);
    }
}

