/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.reconcile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilableModel;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.jst.jsp.core.internal.java.ELProblem;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationAdapter;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.ui.internal.reconcile.JSPTranslationWrapper;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.StringUtils;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentAdapter;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredReconcileStep;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;

public class ReconcileStepForJspTranslation
extends StructuredReconcileStep {
    private JSPTranslationWrapper fModel = null;
    private IReconcileResult[] EMPTY_RECONCILE_RESULT_SET = new IReconcileResult[0];
    private JSPTranslationAdapter fTranslationAdapter = null;
    private JSPTranslationExtension fJSPTranslation = null;
    static /* synthetic */ Class class$0;

    public ReconcileStepForJspTranslation(IReconcileStep step) {
        super(step);
    }

    protected IReconcileResult[] reconcileModel(DirtyRegion dirtyRegion, IRegion subRegion) {
        if (DEBUG) {
            System.out.println("[trace reconciler] > translating JSP in JSP TRANSLATE step");
        }
        if (this.isCanceled() || dirtyRegion == null) {
            return this.EMPTY_RECONCILE_RESULT_SET;
        }
        JSPTranslationAdapter adapter = this.getJSPTranslationAdapter();
        this.fJSPTranslation = adapter.getJSPTranslation();
        this.fModel = new JSPTranslationWrapper(this.fJSPTranslation);
        if (DEBUG) {
            System.out.println("[trace reconciler] > JSP TRANSLATE step done");
        }
        return this.adaptELProblems();
    }

    private IReconcileResult[] adaptELProblems() {
        List problems = this.fJSPTranslation.getELProblems();
        TemporaryAnnotation[] annotations = new TemporaryAnnotation[problems.size()];
        int i = 0;
        while (i < problems.size()) {
            annotations[i] = this.createTemporaryAnnotationFromProblem((ELProblem)problems.get(i));
            ++i;
        }
        return annotations;
    }

    private TemporaryAnnotation createTemporaryAnnotationFromProblem(ELProblem problem) {
        IStructuredDocument sDoc = (IStructuredDocument)((DocumentAdapter)this.getInputModel()).getDocument();
        String type = "org.eclipse.wst.sse.ui.temp.error";
        ReconcileAnnotationKey key = null;
        key = this.createKey(sDoc.getRegionAtCharacterOffset(problem.getPosition().getOffset()), 0);
        TemporaryAnnotation annotation = new TemporaryAnnotation(problem.getPosition(), type, problem.getMessage(), key);
        annotation.setAdditionalFixInfo((Object)problem);
        return annotation;
    }

    /*
     * Exception decompiling
     */
    private JSPTranslationAdapter getJSPTranslationAdapter() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 131->134)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IReconcilableModel getModel() {
        return this.fModel;
    }

    protected IReconcileResult[] convertToInputModel(IReconcileResult[] inputResults) {
        if (inputResults == null) {
            return this.EMPTY_RECONCILE_RESULT_SET;
        }
        ArrayList<TemporaryAnnotation> filtered = new ArrayList<TemporaryAnnotation>();
        HashMap java2jspRanges = this.fJSPTranslation.getJava2JspMap();
        int i = 0;
        while (i < inputResults.length) {
            if (this.isCanceled()) {
                return this.EMPTY_RECONCILE_RESULT_SET;
            }
            if (inputResults[i] instanceof TemporaryAnnotation) {
                TemporaryAnnotation result = (TemporaryAnnotation)inputResults[i];
                this.adaptJava2JspPosition(result, java2jspRanges);
                if (result.getPosition().offset != -1) {
                    filtered.add(result);
                }
            }
            ++i;
        }
        return filtered.toArray(new IReconcileResult[filtered.size()]);
    }

    private void adaptJava2JspPosition(TemporaryAnnotation annotation, HashMap java2jspRanges) {
        Position pos = annotation.getPosition();
        int javaOffset = pos.offset;
        int offsetInRange = 0;
        Position javaPos = null;
        boolean found = false;
        Iterator it = java2jspRanges.keySet().iterator();
        while (it.hasNext()) {
            javaPos = (Position)it.next();
            if (!javaPos.includes(javaOffset)) continue;
            offsetInRange = javaOffset - javaPos.offset;
            Position jspPos = (Position)java2jspRanges.get(javaPos);
            if (jspPos == null) break;
            pos.offset = jspPos.offset + offsetInRange;
            found = true;
            this.additionalPositionAdjustment(annotation, jspPos);
            break;
        }
        if (!found) {
            pos.offset = -1;
            pos.length = 0;
        }
    }

    private void additionalPositionAdjustment(TemporaryAnnotation annotation, Position jspPos) {
        Position pos = annotation.getPosition();
        IStructuredDocument sDoc = null;
        IStructuredDocumentRegion sdRegion = null;
        ITextRegionList regions = null;
        ITextRegion r = null;
        String tagName = "";
        sDoc = (IStructuredDocument)((DocumentAdapter)this.getInputModel()).getDocument();
        sdRegion = sDoc.getRegionAtCharacterOffset(jspPos.offset);
        regions = sdRegion.getRegions();
        int i = 0;
        while (i < regions.size()) {
            r = regions.get(i);
            if (r.getType() == "JSP_DIRECTIVE_NAME" || r.getType() == "XML_TAG_NAME") {
                tagName = sdRegion.getText(r).trim();
                if (tagName.equals("include") || tagName.equals("jsp:directive.include")) {
                    this.adjustForInclude(annotation, pos, sdRegion, regions, i);
                } else if (tagName.equals("page") || tagName.equals("jsp:directive.page")) {
                    this.adjustForPage(annotation, pos, sdRegion, regions, i);
                } else if (tagName.equals("jsp:useBean")) {
                    this.adjustForUseBean(pos, sdRegion, regions, i);
                    break;
                }
            }
            ++i;
        }
    }

    private void adjustForInclude(TemporaryAnnotation annotation, Position pos, IStructuredDocumentRegion sdRegion, ITextRegionList regions, int startingRegionNumber) {
        int j = startingRegionNumber;
        while (j < regions.size()) {
            ITextRegion r = regions.get(j);
            if (r.getType() == "XML_TAG_ATTRIBUTE_NAME" && !sdRegion.getText(r).trim().equals("file")) break;
            if (r.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                String tagName = sdRegion.getText(r).trim();
                String noQuotes = StringUtils.strip((String)tagName);
                pos.offset = sdRegion.getStartOffset(r) + (tagName.length() - noQuotes.length() == 2 ? 1 : 0);
                pos.length = noQuotes.length();
                annotation.setText(String.valueOf(annotation.getText()) + " (in file: \"" + noQuotes + "\")");
                break;
            }
            ++j;
        }
    }

    private void adjustForPage(TemporaryAnnotation annotation, Position pos, IStructuredDocumentRegion sdRegion, ITextRegionList regions, int startingRegionNumber) {
        int size = regions.size();
        int j = startingRegionNumber;
        while (j < size) {
            ITextRegion r = regions.get(j);
            if (r.getType() == "XML_TAG_ATTRIBUTE_NAME" && sdRegion.getText(r).trim().equals("import") && size > j + 2 && (r = regions.get(j + 2)).getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                String value = sdRegion.getText(r);
                pos.offset = sdRegion.getStartOffset(r);
                pos.length = value.trim().length();
                annotation.setText(String.valueOf(annotation.getText()) + " (in file: \"" + StringUtils.stripQuotes((String)value) + "\")");
                break;
            }
            ++j;
        }
    }

    private void adjustForUseBean(Position pos, IStructuredDocumentRegion sdRegion, ITextRegionList regions, int startingRegionNumber) {
        int size = regions.size();
        int j = startingRegionNumber;
        while (j < size) {
            ITextRegion r = regions.get(j);
            if (r.getType() == "XML_TAG_ATTRIBUTE_NAME" && sdRegion.getText(r).trim().equals("id") && size > j + 2 && (r = regions.get(j + 2)).getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                String value = sdRegion.getText(r);
                pos.offset = sdRegion.getStartOffset(r);
                pos.length = value.trim().length();
                break;
            }
            ++j;
        }
    }

    public void release() {
        if (this.fTranslationAdapter != null) {
            if (DEBUG) {
                System.out.println("ReconcileStepForJSPTranslation [" + (Object)((Object)this) + "] releasing JSPTranslationAdapter " + this.fTranslationAdapter);
            }
            this.fTranslationAdapter.release();
        }
        super.release();
    }

    public void setInputModel(IReconcilableModel inputModel) {
        this.fTranslationAdapter = null;
        if (DEBUG) {
            System.out.println("======================================");
            System.out.println("setting input model" + inputModel);
            System.out.println("======================================");
        }
        super.setInputModel(inputModel);
        this.reinitTranslationAdapter(inputModel);
    }

    /*
     * Exception decompiling
     */
    private void reinitTranslationAdapter(IReconcilableModel inputModel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 76->80)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

