/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.java.refactoring;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.java.refactoring.JSPJavaSelectionProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.sse.ui.internal.util.PlatformStatusLineUtil;

public class JSPRenameElementAction
extends TextEditorAction {
    public JSPRenameElementAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public boolean isEnabled() {
        return true;
    }

    public void update() {
        super.update();
        PlatformStatusLineUtil.clearStatusLine();
    }

    private IJavaElement getSelectedElement() {
        IJavaElement[] elements;
        IJavaElement element = null;
        if (this.getTextEditor() != null && (elements = JSPJavaSelectionProvider.getSelection(this.getTextEditor())).length == 1) {
            element = elements[0];
        }
        return element;
    }

    public void run() {
        IJavaElement element = this.getSelectedElement();
        if (element != null) {
            RenameSupport renameSupport = null;
            try {
                switch (element.getElementType()) {
                    case 7: {
                        renameSupport = RenameSupport.create((IType)((IType)element), (String)element.getElementName(), (int)1);
                        break;
                    }
                    case 9: {
                        renameSupport = RenameSupport.create((IMethod)((IMethod)element), (String)element.getElementName(), (int)1);
                        break;
                    }
                    case 4: {
                        renameSupport = RenameSupport.create((IPackageFragment)((IPackageFragment)element), (String)element.getElementName(), (int)1);
                    }
                }
                if (renameSupport != null) {
                    renameSupport.openDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    PlatformStatusLineUtil.clearStatusLine();
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        } else {
            PlatformStatusLineUtil.displayErrorMessage((String)JSPUIMessages.JSPRenameElementAction_0);
            PlatformStatusLineUtil.addOneTimeClearListener();
        }
    }
}

