/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.StringUtils;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.sse.ui.internal.contentassist.IRelevanceCompletionProposal;

public class JavaTypeCompletionProposal
extends CustomCompletionProposal
implements IRelevanceCompletionProposal {
    private int fCursorPosition = 0;
    private String fLocalDisplayString;
    private String fShortName;
    private String fQualifiedName;
    private String fContainerName;

    public JavaTypeCompletionProposal(String replacementString, int replacementOffset, int replacementLength, String qualifiedName, Image image, String typeName, String containerName, int relevence, boolean updateReplacementLengthOnValidate) {
        super(replacementString, replacementOffset, replacementLength, qualifiedName.length() + 2, image, containerName != null && containerName.length() > 0 ? String.valueOf(typeName) + " - " + containerName : typeName, null, null, relevence, true);
        this.fShortName = typeName;
        this.fQualifiedName = qualifiedName;
        this.fContainerName = containerName;
        this.fCursorPosition = this.fQualifiedName.length() + 2;
        this.fLocalDisplayString = containerName != null && containerName.length() > 0 ? String.valueOf(typeName) + " - " + containerName : typeName;
    }

    public String getDisplayString() {
        return this.fLocalDisplayString;
    }

    public int getCursorPosition() {
        return this.fCursorPosition;
    }

    public void setCursorPosition(int cursorPosition) {
        super.setCursorPosition(cursorPosition);
        this.fCursorPosition = cursorPosition;
    }

    public String getQualifiedName() {
        return this.fQualifiedName;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getShortName() {
        return this.fShortName;
    }

    protected String getImport(IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        String importSpec = null;
        boolean isImport = false;
        int i = 0;
        while (i < regions.size()) {
            ITextRegion region = regions.get(i);
            if (region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                isImport = flatNode.getText(region).equals("import");
            } else if (isImport && region.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                importSpec = flatNode.getText(region);
            }
            ++i;
        }
        return importSpec;
    }

    protected int applyImport(IStructuredDocument model) {
        if (this.fContainerName == null || this.fContainerName.length() == 0 || this.fContainerName.equals("java.lang")) {
            return 0;
        }
        ArrayList<String> imports = new ArrayList<String>();
        IStructuredDocumentRegion node = model.getFirstStructuredDocumentRegion();
        int hint = 0;
        boolean useXML = false;
        while (node != null) {
            ITextRegionList regions = node.getRegions();
            if (regions.size() > 1) {
                ITextRegion name = regions.get(1);
                if (name.getType() == "JSP_DIRECTIVE_NAME") {
                    if (node.getText(name).equals("page") || node.getText(name).equals("jsp:directive.page")) {
                        String importSpec;
                        if (node.getEndOffset() < this.getReplacementOffset()) {
                            hint = node.getEndOffset();
                        }
                        if ((importSpec = this.getImport(node)) != null) {
                            imports.add(importSpec);
                        }
                    }
                } else {
                    useXML = useXML || name.getType() == "JSP_ROOT_TAG_NAME";
                }
            }
            node = node.getNext();
        }
        boolean needsImport = !this.importHandles(this.fQualifiedName, imports);
        int adjustmentLength = 0;
        if (needsImport) {
            String directive = null;
            directive = useXML ? "<jsp:directive.page import=\"" + this.fQualifiedName + "\"/>" : "<%@ page import=\"" + this.fQualifiedName + "\" %>";
            try {
                boolean appendNewLine;
                IRegion line = model.getLineInformationOfOffset(hint);
                boolean prependNewLine = line.getOffset() + line.getLength() == hint;
                boolean bl = appendNewLine = hint == 0;
                if (prependNewLine) {
                    directive = String.valueOf(model.getLineDelimiter()) + directive;
                }
                if (appendNewLine) {
                    directive = String.valueOf(directive) + model.getLineDelimiter();
                }
                adjustmentLength = directive.length();
            }
            catch (BadLocationException badLocationException) {}
            try {
                model.replace(hint, 0, directive);
            }
            catch (BadLocationException badLocationException) {
                try {
                    model.replace(this.getReplacementOffset(), 0, directive);
                    adjustmentLength = directive.length();
                }
                catch (BadLocationException badLocationException2) {}
            }
        }
        return adjustmentLength;
    }

    protected boolean isWildcardMatch(String importSpec, String type) {
        String container;
        int specLength = importSpec.length();
        return importSpec.endsWith("*") && specLength > 2 && type.length() >= specLength && type.startsWith(container = importSpec.substring(0, specLength - 1)) && type.indexOf(46, specLength - 1) < 0;
    }

    protected boolean importHandles(String type, List listOfImports) {
        Iterator imports = listOfImports.iterator();
        while (imports.hasNext()) {
            String importSpec = StringUtils.strip((String)imports.next().toString());
            if (!importSpec.equals(type) && !this.isWildcardMatch(importSpec, type)) continue;
            return true;
        }
        return false;
    }

    public void apply(IDocument document, char trigger, int offset) {
        boolean addShortForm = false;
        if (addShortForm) {
            this.setReplacementString(String.valueOf('\"') + this.fShortName + '\"');
            int importLength = this.applyImport((IStructuredDocument)document);
            this.setReplacementOffset(this.getReplacementOffset() + importLength);
        }
        this.setCursorPosition(this.getReplacementString().length());
        super.apply(document, trigger, offset);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.apply(viewer.getDocument(), trigger, offset);
    }

    protected boolean startsWith(IDocument document, int offset, String word) {
        int wordLength;
        int n = wordLength = word == null ? 0 : word.length();
        if (offset > this.getReplacementOffset() + wordLength) {
            return false;
        }
        try {
            int length = offset - this.getReplacementOffset();
            String start = StringUtils.stripQuotes((String)document.get(this.getReplacementOffset(), length));
            return word.toLowerCase().startsWith(start.toLowerCase()) || this.fQualifiedName.toLowerCase().startsWith(start.toLowerCase());
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
        super.selected(viewer, false);
    }
}

