/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.internal.deployables;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.util.WebResource;
import org.eclipse.wst.web.internal.operation.IBaseWebNature;
import org.eclipse.wst.web.internal.operation.StaticWebNatureRuntime;

public class StaticWebDeployableObjectAdapterUtil {
    private static final String[] extensionsToExclude = new String[]{"sql", "xmi"};
    static String J2EE_NATURE_ID = "org.eclipse.jst.j2ee.web.WebNature";
    static String INFO_DIRECTORY = "WEB-INF";
    static /* synthetic */ Class class$0;

    public static IBaseWebNature getRuntime(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            IBaseWebNature nature = project.hasNature(J2EE_NATURE_ID) ? (IBaseWebNature)project.getNature(J2EE_NATURE_ID) : (IBaseWebNature)project.getNature("org.eclipse.wst.web.StaticWebNature");
            return nature;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IModuleArtifact getModuleObject(Object obj) {
        IResource resource = null;
        if (obj instanceof IResource) {
            resource = (IResource)obj;
        } else if (obj instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        if (resource == null) {
            return null;
        }
        IBaseWebNature webNature = StaticWebDeployableObjectAdapterUtil.getRuntime(resource.getProject());
        if (webNature == null || !(webNature instanceof StaticWebNatureRuntime)) {
            return null;
        }
        if (resource instanceof IProject) {
            return new WebResource(StaticWebDeployableObjectAdapterUtil.getModule(webNature), (IPath)new Path(""));
        }
        IPath rootPath = webNature.getRootPublishableFolder().getProjectRelativePath();
        IPath resourcePath = resource.getProjectRelativePath();
        if (resourcePath.matchingFirstSegments(rootPath) != rootPath.segmentCount()) {
            return null;
        }
        if ((resourcePath = resourcePath.removeFirstSegments(rootPath.segmentCount())).segmentCount() > 1 && resourcePath.segment(0).equals(INFO_DIRECTORY)) {
            return null;
        }
        if (StaticWebDeployableObjectAdapterUtil.shouldExclude(resource)) {
            return null;
        }
        return new WebResource(StaticWebDeployableObjectAdapterUtil.getModule(webNature), resourcePath);
    }

    private static boolean shouldExclude(IResource resource) {
        String fileExt = resource.getFileExtension();
        int i = 0;
        while (i < extensionsToExclude.length) {
            String extension = extensionsToExclude[i];
            if (extension.equalsIgnoreCase(fileExt)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static IModule getModule(IBaseWebNature nature) {
        IModule deployable = nature.getModule();
        if (deployable != null) {
            return deployable;
        }
        IProject project = nature.getProject();
        Iterator<IModule> iterator = Arrays.asList(ServerUtil.getModules((String)"web.static")).iterator();
        while (iterator.hasNext()) {
            deployable = iterator.next();
            if (deployable == null || !deployable.getProject().equals((Object)project)) continue;
            return deployable;
        }
        return null;
    }
}

