/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.wizard.test;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.j2ee.internal.webservices.WebServicesClientDataHelper;
import org.eclipse.jst.ws.internal.axis.consumption.ui.command.AxisClientGenerator;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;

public class TestWizardPage
extends WizardPage {
    private String pluginId_ = "org.eclipse.jst.ws.axis.consumption.ui";
    private MessageUtils msgUtils_;
    private Text wsdlURIText_;
    private Text clientProjectText_;
    private Text serviceQNameText_;
    private Text outputWSDLPathText_;
    private Button goButton_;
    private Button pop1Button_;
    private Button pop2Button_;

    public TestWizardPage(String name) {
        super(name);
        this.setTitle("Test Page");
        this.setDescription("Test page description");
    }

    public void createControl(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        page.setLayout((Layout)gl);
        GridData gd = new GridData(272);
        page.setLayoutData((Object)gd);
        page.setSize(500, 500);
        Composite outerGroup_ = new Composite(page, 0);
        GridLayout gl2 = new GridLayout();
        gl2.numColumns = 2;
        gl2.marginHeight = 0;
        gl2.marginWidth = 0;
        outerGroup_.setLayout((Layout)gl2);
        GridData gd2 = new GridData(1808);
        outerGroup_.setLayoutData((Object)gd2);
        this.msgUtils_ = new MessageUtils(String.valueOf(this.pluginId_) + ".plugin", (Object)this);
        UIUtils uiUtils = new UIUtils(this.msgUtils_, this.pluginId_);
        this.wsdlURIText_ = uiUtils.createText(outerGroup_, "wsdlURI", "wsdlURI", "wsdlURI", 2052);
        this.clientProjectText_ = uiUtils.createText(outerGroup_, "clientProject", "clientProject", "clientProject", 2052);
        this.serviceQNameText_ = uiUtils.createText(outerGroup_, "serviceQName", "serviceQName", "", 2052);
        this.outputWSDLPathText_ = uiUtils.createText(outerGroup_, "outputWSDLpath", "outputWSDLpath", "", 2052);
        this.goButton_ = uiUtils.createButton(8, outerGroup_, "GO", "GO", "");
        this.goButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestWizardPage.this.handleGOPushed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TestWizardPage.this.handleGOPushed();
            }
        });
        this.pop1Button_ = uiUtils.createButton(8, outerGroup_, "pop1", "pop1", "");
        this.pop1Button_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestWizardPage.this.handlePop1Pushed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TestWizardPage.this.handlePop1Pushed();
            }
        });
        this.pop2Button_ = uiUtils.createButton(8, outerGroup_, "pop2", "pop2", "");
        this.pop2Button_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestWizardPage.this.handlePop2Pushed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TestWizardPage.this.handlePop2Pushed();
            }
        });
        this.setControl((Control)page);
    }

    private void handlePop1Pushed() {
        this.wsdlURIText_.setText("http://www.xmethods.net/sd/2001/TemperatureService.wsdl");
        this.clientProjectText_.setText("cwp");
        this.serviceQNameText_.setText("http://www.xmethods.net/sd/TemperatureService.wsdl:TemperatureService");
        this.outputWSDLPathText_.setText("/cwp/Web Content/WEB-INF/wsdl/TemperatureService.wsdl");
    }

    private void handlePop2Pushed() {
        this.wsdlURIText_.setText("file:/D:/Eclipse/eclipse/runtime-workspace_t1/wp2/Web Content/Converters.wsdl");
        this.clientProjectText_.setText("cwp2");
        this.serviceQNameText_.setText("http://sample.converters:ConvertDistanceService");
        this.outputWSDLPathText_.setText("/cwp2/Web Content/WEB-INF/wsdl/Converters.wsdl");
    }

    private void handleGOPushed() {
        AxisClientGenerator generator = new AxisClientGenerator();
        TestWSCDataHelper dataModel = new TestWSCDataHelper();
        dataModel.populate(this.wsdlURIText_.getText(), this.serviceQNameText_.getText(), this.clientProjectText_.getText(), this.outputWSDLPathText_.getText(), false);
        generator.genWebServiceClientArtifacts(dataModel);
        System.out.println("Generated service interface= " + dataModel.getServiceInterfaceName());
        String[] seis = dataModel.getServiceEndpointInterfaceNames();
        System.out.println("Generated service endpoint interfaces:");
        int i = 0;
        while (i < seis.length) {
            System.out.println(seis[i]);
            ++i;
        }
        System.out.println("Touched descriptors? " + dataModel.shouldGenDescriptors());
    }

    private class TestWSCDataHelper
    implements WebServicesClientDataHelper {
        private String wsdlUrl_;
        private String serviceQName_;
        private String projectName_;
        private String outputWSDLFileName_;
        private String serviceInterfaceName_;
        private String[] serviceEndpointInterfaceNames_;
        private boolean shouldDeploy_;
        private boolean shouldGenDescriptors_;

        TestWSCDataHelper() {
        }

        public void populate(String wsdlURL, String serviceQName, String projectName, String outputWSDLFileName, boolean shouldDeploy) {
            this.wsdlUrl_ = wsdlURL;
            this.serviceQName_ = serviceQName;
            this.projectName_ = projectName;
            this.outputWSDLFileName_ = outputWSDLFileName;
            this.shouldDeploy_ = shouldDeploy;
        }

        public String getWSDLUrl() {
            return this.wsdlUrl_;
        }

        public String getServiceQName() {
            return this.serviceQName_;
        }

        public String getProjectName() {
            return this.projectName_;
        }

        public String getOutputWSDLFileName() {
            return this.outputWSDLFileName_;
        }

        public String getServiceInterfaceName() {
            return this.serviceInterfaceName_;
        }

        public String[] getServiceEndpointInterfaceNames() {
            return this.serviceEndpointInterfaceNames_;
        }

        public boolean shouldDeploy() {
            return this.shouldDeploy_;
        }

        public boolean shouldGenDescriptors() {
            return this.shouldGenDescriptors_;
        }

        public void setServiceInterfaceName(String name) {
            this.serviceInterfaceName_ = name;
        }

        public void setServiceEndpointInterfaceNames(String[] names) {
            this.serviceEndpointInterfaceNames_ = names;
        }

        public void setDidGenDescriptors(boolean b) {
            this.shouldGenDescriptors_ = b;
        }

        public void genWebServiceClientArtifacts(WebServicesClientDataHelper dataModel) {
        }
    }
}

