/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.task;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.plugin.JavaEMFNature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.impl.JavaClassImpl;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.WSDLUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.ProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;

public class Stub2BeanInfo {
    private final String NEW_LINE = System.getProperty("line.separator");
    private int indentCount = 0;
    private String package_ = null;
    private StringBuffer imports_ = new StringBuffer();
    private StringBuffer seis_ = new StringBuffer();
    private StringBuffer services_ = new StringBuffer();
    private StringBuffer jndiNames_ = new StringBuffer();
    private StringBuffer ports_ = new StringBuffer();
    private String class_ = "SEIBean";
    private Vector usedNames = new Vector();
    private IProject clientProject_;
    private String moduleName_;

    public void setClientProject(IProject clientProject) {
        this.clientProject_ = clientProject;
    }

    public void setClientModuleName(String moduleName) {
        this.moduleName_ = moduleName;
    }

    public void setPackage(String pkgName) {
        if (pkgName != null && pkgName.length() > 0) {
            this.package_ = this.manglePackageName(pkgName);
        }
    }

    public void addImports(String pkgName, String className) {
        this.imports_.append(this.toFullyQualifiedClassName(pkgName, className));
        this.imports_.append(";");
    }

    public void addSEI(String seiPkgName, String seiClassName, String servicePkgName, String serviceClassName, String portName) {
        this.addSEI(seiPkgName, seiClassName, servicePkgName, serviceClassName, serviceClassName, portName);
    }

    public void addSEI(String seiPkgName, String seiClassName, String servicePkgName, String serviceClassName, String jndiName, String portName) {
        this.seis_.append(this.toFullyQualifiedClassName(seiPkgName, seiClassName));
        this.seis_.append(";");
        this.services_.append(this.toFullyQualifiedClassName(servicePkgName, serviceClassName));
        this.services_.append(";");
        this.jndiNames_.append(jndiName);
        this.jndiNames_.append(";");
        this.ports_.append(portName);
        this.ports_.append(";");
    }

    public void setClass(String className) {
        if (className != null && className.length() > 0) {
            this.class_ = this.mangleClassName(className);
        }
    }

    private String toFullyQualifiedClassName(String pkgName, String className) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.manglePackageName(pkgName));
        sb.append(".");
        sb.append(this.mangleClassName(className));
        return sb.toString();
    }

    private String getPackageName(String qname) {
        int index = qname.lastIndexOf(".");
        if (index != -1) {
            return qname.substring(0, index);
        }
        return qname;
    }

    private String getClassName(String qname) {
        int index = qname.lastIndexOf(".");
        if (index != -1) {
            return qname.substring(index + 1, qname.length());
        }
        return qname;
    }

    private String manglePackageName(String s) {
        return this.replaceInvalidJavaChars(s);
    }

    private String mangleClassName(String s) {
        s = this.firstCharToUpperCase(WSDLUtils.resolveDotInPortName(s));
        return this.replaceInvalidJavaChars(s);
    }

    private String replaceInvalidJavaChars(String s) {
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (!Character.isJavaIdentifierPart(c[i])) {
                c[i] = 46;
            }
            ++i;
        }
        return new String(c);
    }

    private String firstCharToUpperCase(String s) {
        StringBuffer sb = new StringBuffer();
        sb.append(s.substring(0, 1).toUpperCase());
        sb.append(s.substring(1, s.length()));
        return sb.toString();
    }

    private String firstCharToLowerCase(String s) {
        StringBuffer sb = new StringBuffer();
        sb.append(s.substring(0, 1).toLowerCase());
        sb.append(s.substring(1, s.length()));
        return sb.toString();
    }

    private String trimArraySymbol(String s) {
        int index = s.indexOf("[");
        if (index != -1) {
            return s.substring(0, index);
        }
        return s;
    }

    private String getFullyQualifiedName(JavaHelpers javaHelpers) {
        if (javaHelpers.isPrimitive()) {
            return javaHelpers.getJavaName();
        }
        return javaHelpers.getQualifiedName();
    }

    public void write(ProgressMonitor progressMonitor, StatusHandler statusMonitor) throws CoreException, IOException {
        StringWriter sw = new StringWriter(2048);
        this.writePackage(sw);
        this.writeImports(sw);
        this.writeClass(sw);
        sw.close();
        byte[] bytes = sw.getBuffer().toString().getBytes();
        StringBuffer sb = new StringBuffer();
        if (this.package_ != null && this.package_.length() > 0) {
            sb.append(this.package_);
            sb.append(".");
        }
        sb.append(this.class_);
        sb = new StringBuffer(sb.toString().replace('.', '/'));
        sb.append(".java");
        JavaEMFNature.createRuntime((IProject)this.clientProject_);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        IPath sourceFolderPath = ResourceUtils.getJavaSourceLocation((IProject)this.clientProject_, (String)this.moduleName_);
        IFolder sourceFolder = (IFolder)ResourceUtils.findResource((IPath)sourceFolderPath);
        IPath filePath = sourceFolder.getFile((IPath)new Path(sb.toString())).getFullPath();
        FileResourceUtils.createFile((ResourceContext)WebServicePlugin.getInstance().getResourceContext(), (IPath)filePath, (InputStream)bais, (ProgressMonitor)progressMonitor, (StatusHandler)statusMonitor);
    }

    private void writePackage(Writer w) throws IOException {
        if (this.package_ != null && this.package_.length() > 0) {
            w.write("package ");
            w.write(this.package_);
            w.write(";");
            this.newLine(w);
        }
    }

    private void writeImports(Writer w) throws IOException {
        StringTokenizer st = new StringTokenizer(this.imports_.toString(), ";");
        while (st.hasMoreTokens()) {
            w.write("import ");
            w.write(st.nextToken());
            w.write(";");
            this.newLine(w);
        }
    }

    private void writeClass(Writer w) throws IOException, CoreException {
        this.newLine(w);
        w.write("public class ");
        w.write(this.class_);
        w.write(" ");
        StringTokenizer st = new StringTokenizer(this.seis_.toString(), ";");
        if (st.hasMoreTokens()) {
            w.write("implements ");
        }
        while (st.hasMoreTokens()) {
            w.write(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            w.write(", ");
        }
        w.write(" {");
        this.incrementIndent();
        this.newLine(w);
        this.writeFieldsDeclarations(w);
        this.writeConstructor(w);
        this.writeInit(w);
        this.writeGetSetEndpoint(w);
        this.writeSEIGetters(w);
        this.writeSEIMethods(w);
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
    }

    private void writeFieldsDeclarations(Writer w) throws IOException {
        w.write("private String _endpoint = null;");
        this.usedNames.add("_endpoint");
        this.newLine(w);
        StringTokenizer st = new StringTokenizer(this.seis_.toString(), ";");
        while (st.hasMoreTokens()) {
            w.write("private ");
            String sei = st.nextToken();
            w.write(sei);
            w.write(" ");
            String stubName = this.firstCharToLowerCase(this.getClassName(sei));
            w.write(stubName);
            this.usedNames.add(stubName);
            w.write(" = null;");
            this.newLine(w);
        }
    }

    private void writeConstructor(Writer w) throws IOException {
        this.newLine(w);
        w.write("public ");
        w.write(this.class_);
        w.write("() {");
        this.incrementIndent();
        this.newLine(w);
        w.write("_init");
        w.write(this.class_);
        w.write("();");
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
        this.newLine(w);
    }

    private void writeInit(Writer w) throws IOException {
        this.newLine(w);
        w.write("private void _init");
        w.write(this.class_);
        w.write("() {");
        this.incrementIndent();
        this.newLine(w);
        w.write("try {");
        this.incrementIndent();
        this.newLine(w);
        StringTokenizer st = new StringTokenizer(this.seis_.toString(), ";");
        StringTokenizer serviceTokens = new StringTokenizer(this.services_.toString(), ";");
        new StringTokenizer(this.jndiNames_.toString(), ";");
        StringTokenizer portTokens = new StringTokenizer(this.ports_.toString(), ";");
        while (st.hasMoreTokens()) {
            String seiName = this.firstCharToLowerCase(this.getClassName(st.nextToken()));
            w.write(seiName);
            w.write(" = (new ");
            w.write(serviceTokens.nextToken());
            w.write("Locator()).get");
            w.write(this.replaceInvalidJavaChars(WSDLUtils.resolveDotInPortName(portTokens.nextToken())));
            w.write("();");
            this.newLine(w);
            w.write("if (");
            w.write(seiName);
            w.write(" != null) {");
            this.incrementIndent();
            this.newLine(w);
            w.write("if (_endpoint != null)");
            this.incrementIndent();
            this.newLine(w);
            w.write("((javax.xml.rpc.Stub)");
            w.write(seiName);
            w.write(")._setProperty(\"javax.xml.rpc.service.endpoint.address\", _endpoint);");
            this.decrementIndent();
            this.newLine(w);
            w.write("else");
            this.incrementIndent();
            this.newLine(w);
            w.write("_endpoint = (String)((javax.xml.rpc.Stub)");
            w.write(seiName);
            w.write(")._getProperty(\"javax.xml.rpc.service.endpoint.address\");");
            this.decrementIndent();
            this.decrementIndent();
            this.newLine(w);
            w.write("}");
            this.newLine(w);
        }
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
        this.newLine(w);
        w.write("catch (javax.xml.rpc.ServiceException serviceException) {}");
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
        this.newLine(w);
    }

    private void writeSetPropertyEndpoint(Writer w) throws IOException {
        StringTokenizer st = new StringTokenizer(this.seis_.toString(), ";");
        while (st.hasMoreTokens()) {
            String seiName = this.firstCharToLowerCase(this.getClassName(st.nextToken()));
            w.write("if (");
            w.write(seiName);
            w.write(" != null)");
            this.incrementIndent();
            this.newLine(w);
            w.write("((javax.xml.rpc.Stub)");
            w.write(seiName);
            w.write(")._setProperty(\"javax.xml.rpc.service.endpoint.address\", _endpoint);");
            this.decrementIndent();
            this.newLine(w);
        }
    }

    private void writeUseJNDI(Writer w) throws IOException {
        this.newLine(w);
        w.write("public void useJNDI(boolean useJNDI) {");
        this.incrementIndent();
        this.newLine(w);
        w.write("_useJNDI = useJNDI;");
        this.newLine(w);
        StringTokenizer st = new StringTokenizer(this.seis_.toString(), ";");
        while (st.hasMoreTokens()) {
            w.write(this.firstCharToLowerCase(this.getClassName(st.nextToken())));
            w.write(" = null;");
            this.newLine(w);
        }
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
        this.newLine(w);
    }

    private void writeSEIGetters(Writer w) throws IOException {
        StringTokenizer st = new StringTokenizer(this.seis_.toString(), ";");
        while (st.hasMoreTokens()) {
            String sei = st.nextToken();
            String seiClassName = this.getClassName(sei);
            String seiFieldName = this.firstCharToLowerCase(seiClassName);
            this.newLine(w);
            w.write("public ");
            w.write(sei);
            w.write(" get");
            w.write(seiClassName);
            w.write("() {");
            this.incrementIndent();
            this.newLine(w);
            w.write("if (");
            w.write(seiFieldName);
            w.write(" == null)");
            this.incrementIndent();
            this.newLine(w);
            w.write("_init");
            w.write(this.class_);
            w.write("();");
            this.decrementIndent();
            this.newLine(w);
            w.write("return ");
            w.write(seiFieldName);
            w.write(";");
            this.decrementIndent();
            this.newLine(w);
            w.write("}");
            this.newLine(w);
        }
    }

    private void writeSEIMethods(Writer w) throws IOException, CoreException {
        this.newLine(w);
        if (this.clientProject_ == null) {
            return;
        }
        JavaEMFNature javaMOF = JavaEMFNature.createRuntime((IProject)this.clientProject_);
        StringTokenizer st = new StringTokenizer(this.seis_.toString(), ";");
        while (st.hasMoreTokens()) {
            String sei = st.nextToken();
            JavaClass javaClass = (JavaClass)JavaClassImpl.reflect((String)this.getPackageName(sei), (String)this.getClassName(sei), (ResourceSet)javaMOF.getResourceSet());
            if (javaClass == null) continue;
            EList methods = javaClass.getMethods();
            Iterator it = methods.iterator();
            while (it.hasNext()) {
                Method method = (Method)it.next();
                if (method.isConstructor() || method.isNative() || method.getJavaVisibility().getValue() != 0) continue;
                this.writeSEIMethods(w, javaClass, method);
            }
        }
    }

    private void writeSEIMethods(Writer w, JavaClass javaClass, Method method) throws IOException {
        w.write("public ");
        if (method.isVoid()) {
            w.write("void ");
        } else {
            w.write(this.getFullyQualifiedName(method.getReturnType()));
            w.write(" ");
        }
        w.write(method.getName());
        w.write("(");
        JavaParameter[] inputParams = method.listParametersWithoutReturn();
        int i = 0;
        while (i < inputParams.length) {
            if (i > 0) {
                w.write(", ");
            }
            JavaHelpers javaHelpers = inputParams[i].getJavaType();
            w.write(this.getFullyQualifiedName(javaHelpers));
            w.write(" ");
            String paramName = this.getClassName(inputParams[i].getQualifiedName());
            w.write(this.getUnusedName(paramName));
            ++i;
        }
        w.write(")");
        EList exceptions = method.getJavaExceptions();
        if (!exceptions.isEmpty()) {
            w.write(" throws ");
        }
        Iterator it = exceptions.iterator();
        while (it.hasNext()) {
            JavaClass exception = (JavaClass)it.next();
            w.write(exception.getQualifiedNameForReflection());
            if (!it.hasNext()) continue;
            w.write(", ");
        }
        w.write("{");
        this.incrementIndent();
        this.newLine(w);
        String stubName = this.firstCharToLowerCase(javaClass.getName());
        w.write("if (");
        w.write(stubName);
        w.write(" == null)");
        this.incrementIndent();
        this.newLine(w);
        w.write("_init");
        w.write(this.class_);
        w.write("();");
        this.decrementIndent();
        this.newLine(w);
        if (!method.isVoid()) {
            w.write("return ");
        }
        w.write(stubName);
        w.write(".");
        w.write(method.getName());
        w.write("(");
        int i2 = 0;
        while (i2 < inputParams.length) {
            if (i2 > 0) {
                w.write(", ");
            }
            String paramName = this.getClassName(inputParams[i2].getQualifiedName());
            w.write(this.getUnusedName(paramName));
            ++i2;
        }
        w.write(");");
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
        this.newLine(w);
        this.newLine(w);
    }

    private void writeGetSetEndpoint(Writer w) throws IOException {
        this.newLine(w);
        w.write("public String getEndpoint() {");
        this.incrementIndent();
        this.newLine(w);
        w.write("return _endpoint;");
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
        this.newLine(w);
        this.newLine(w);
        w.write("public void setEndpoint(String endpoint) {");
        this.incrementIndent();
        this.newLine(w);
        w.write("_endpoint = endpoint;");
        this.newLine(w);
        this.writeSetPropertyEndpoint(w);
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
        this.newLine(w);
    }

    private void createParentFolder(IResource res) throws CoreException {
        IFolder folder;
        IContainer parent = res.getParent();
        if (parent != null && parent != res && parent instanceof IFolder && !(folder = (IFolder)parent).exists()) {
            this.createParentFolder((IResource)folder);
            folder.create(true, true, null);
        }
    }

    private void incrementIndent() {
        ++this.indentCount;
    }

    private void decrementIndent() {
        --this.indentCount;
    }

    private void indent(Writer w) throws IOException {
        int i = 0;
        while (i < this.indentCount) {
            w.write("  ");
            ++i;
        }
    }

    private void newLine(Writer w) throws IOException {
        w.write(this.NEW_LINE);
        this.indent(w);
    }

    private String getUnusedName(String name) {
        if (this.usedNames.contains(name)) {
            int i = 0;
            while (i < 100) {
                String newName = name + String.valueOf(i);
                if (!this.usedNames.contains(newName)) {
                    return newName;
                }
                ++i;
            }
        }
        return name;
    }
}

