/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.cache.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.internet.cache.internal.Cache;
import org.eclipse.wst.internet.cache.internal.CachePlugin;

public class CacheJob
extends Job {
    private static final String _UI_CACHE_MONITOR_NAME = "_UI_CACHE_MONITOR_NAME";
    private static final String _UI_CACHE_MONITOR_CACHING = "_UI_CACHE_MONITOR_CACHING";
    private String[] specifiedURIsToCache = null;
    private static final long SCHEDULE_TIME = 3600000L;

    public CacheJob() {
        super(CachePlugin.getResourceString(_UI_CACHE_MONITOR_NAME));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        Cache cache = Cache.getInstance();
        String[] uncachedURIs = cache.getUncachedURIs();
        int numUncachedURIs = uncachedURIs.length;
        if (this.specifiedURIsToCache != null) {
            int numSpecifiedURIs = this.specifiedURIsToCache.length;
            String[] temp = new String[numUncachedURIs + numSpecifiedURIs];
            System.arraycopy(this.specifiedURIsToCache, 0, temp, 0, numSpecifiedURIs);
            System.arraycopy(uncachedURIs, 0, temp, numSpecifiedURIs, numUncachedURIs);
            uncachedURIs = temp;
            numUncachedURIs = uncachedURIs.length;
            this.specifiedURIsToCache = null;
        }
        cache.clearUncachedURIs();
        monitor.beginTask(CachePlugin.getResourceString(_UI_CACHE_MONITOR_NAME), numUncachedURIs);
        try {
            int i = 0;
            while (true) {
                if (i >= numUncachedURIs) {
                    monitor.done();
                    iStatus = Status.OK_STATUS;
                    break;
                }
                if (monitor.isCanceled()) {
                    int j = i;
                    while (true) {
                        if (j >= numUncachedURIs) break;
                        cache.addUncachedURI(uncachedURIs[j]);
                        ++j;
                    }
                    IStatus iStatus2 = Status.CANCEL_STATUS;
                    Object var7_10 = null;
                    this.schedule(3600000L);
                    return iStatus2;
                }
                String uri = uncachedURIs[i];
                monitor.subTask(CachePlugin.getResourceString(_UI_CACHE_MONITOR_CACHING, uri));
                cache.getResource(uri);
                monitor.worked(1);
                monitor.subTask("");
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            this.schedule(3600000L);
            throw throwable;
        }
        Object var7_11 = null;
        this.schedule(3600000L);
        return iStatus;
    }
}

