/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.internal.ISaveHandler;
import org.eclipse.wst.common.frameworks.internal.SaveFailedException;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class SaveHandlerUI
implements ISaveHandler {
    public static final String SAVE_FAILED = WTPCommonPlugin.getResourceString((String)"16");
    public static final String BEGINNING_MESSAGE = WTPCommonPlugin.getResourceString((String)"17");
    protected boolean isYesToAll = false;
    protected int referenceCount = 0;

    public void access() {
        ++this.referenceCount;
    }

    protected Shell getParentShellForDialog() {
        if (Display.getCurrent() != null) {
            return Display.getCurrent().getActiveShell();
        }
        return null;
    }

    protected Display getDisplay() {
        Display result = Display.getCurrent();
        return result == null ? Display.getDefault() : result;
    }

    public void handleSaveFailed(SaveFailedException ex, IProgressMonitor monitor) {
        if (this.referenceCount > 1) {
            throw ex;
        }
        String exMsg = ex.getInnerMostNestedException() == null ? ex.getMessage() : ex.getInnerMostNestedException().getMessage();
        final String message = String.valueOf(BEGINNING_MESSAGE) + ":\n" + exMsg;
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)SaveHandlerUI.this.getParentShellForDialog(), (String)SAVE_FAILED, (String)message);
            }
        });
        if (monitor == null) {
            throw ex;
        }
        monitor.setCanceled(true);
    }

    protected boolean promptUserToSaveReadOnly(IFile aFile) {
        String[] buttonStrings = new String[]{WTPCommonPlugin.getResourceString((String)"Yes_UI_"), WTPCommonPlugin.getResourceString((String)"Yes_To_All_UI_"), WTPCommonPlugin.getResourceString((String)"No_UI_")};
        String title = WTPCommonPlugin.getResourceString((String)"Saving_Read-Only_File_UI_");
        String message = WTPCommonPlugin.getResourceString((String)"2concat_INFO_", (Object[])new Object[]{aFile.getFullPath()});
        final MessageDialog dialog = new MessageDialog(this.getParentShellForDialog(), title, null, message, 3, buttonStrings, 0);
        final int[] ret = new int[1];
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.setBlockOnOpen(true);
                ret[0] = dialog.open();
            }
        });
        switch (ret[0]) {
            case 0: {
                return true;
            }
            case 1: {
                this.isYesToAll = true;
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    public void release() {
        --this.referenceCount;
        if (this.referenceCount == 0) {
            this.isYesToAll = false;
        }
    }

    public boolean shouldContinueAndMakeFileEditable(IFile aFile) {
        boolean yes;
        boolean bl = yes = this.isYesToAll || this.promptUserToSaveReadOnly(aFile);
        if (yes) {
            aFile.setReadOnly(false);
        }
        return yes;
    }
}

