/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityXMIResourceImpl;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emf.utilities.IDUtil;

public class ReferencedXMIResourceImpl
extends CompatibilityXMIResourceImpl
implements ReferencedResource {
    private static final String TO_STRING = "ReferencedXMIResource, file = ";
    private static final String READ_COUNT_TO_STRING = " R= ";
    private static final String WRITE_COUNT_TO_STRING = " W= ";
    private int readReferenceCount = 1;
    private int editReferenceCount = 0;
    protected boolean isNew = true;
    protected boolean forceRefresh;

    public ReferencedXMIResourceImpl() {
    }

    public ReferencedXMIResourceImpl(URI uri) {
        super(uri);
    }

    public int getReadCount() {
        return this.readReferenceCount;
    }

    public int getWriteCount() {
        return this.editReferenceCount;
    }

    public void accessForRead() {
        this.checkDeleted();
        if (!this.isNew()) {
            ++this.readReferenceCount;
        }
        this.isNew = false;
    }

    public void accessForWrite() {
        this.checkDeleted();
        ++this.editReferenceCount;
        if (this.isNew) {
            this.releaseFromRead();
        }
        this.isNew = false;
        if (!this.isTrackingModification()) {
            this.setTrackingModification(true);
        }
    }

    protected void checkDeleted() {
        if (this.getResourceSet() == null) {
            throw new RuntimeException("This resource has been deleted and can no longer be used.");
        }
    }

    public void collectContainedObjects(List collecting, EObject parentObject) {
        Iterator children = parentObject.eContents().iterator();
        while (children.hasNext()) {
            EObject child = (EObject)children.next();
            collecting.add(child);
            this.collectContainedObjects(collecting, child);
        }
    }

    public void ensureFullIDHydration() {
        ArrayList<EObject> allRefObjects = new ArrayList<EObject>();
        Iterator rootObjects = this.getContents().iterator();
        while (rootObjects.hasNext()) {
            EObject child = (EObject)rootObjects.next();
            allRefObjects.add(child);
            this.collectContainedObjects(allRefObjects, child);
        }
        Iterator iter = allRefObjects.iterator();
        while (iter.hasNext()) {
            IDUtil.assignID((EObject)iter.next(), (XMLResource)this);
        }
    }

    public void unloadIfNecessary() {
        if (this.getTotalReferenceCount() <= 0 || this.editReferenceCount <= 0 && this.isModified()) {
            this.unload();
        }
    }

    protected int getTotalReferenceCount() {
        return this.editReferenceCount + this.readReferenceCount;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isReadOnly() {
        return this.editReferenceCount <= 0;
    }

    public boolean isShared() {
        return this.getTotalReferenceCount() > 1;
    }

    public boolean isSharedForWrite() {
        return this.editReferenceCount > 1;
    }

    public void preDelete() {
    }

    public void releaseFromRead() {
        --this.readReferenceCount;
        if (this.readReferenceCount < 0) {
            throw new RuntimeException("Read reference count error:  " + this.toString());
        }
        this.unloadIfNecessary();
    }

    public void releaseFromWrite() {
        --this.editReferenceCount;
        if (this.editReferenceCount < 0) {
            throw new RuntimeException("Write reference count error:  " + this.toString());
        }
        this.unloadIfNecessary();
    }

    public void saveIfNecessary() throws Exception {
        if (!this.isSharedForWrite()) {
            this.save(Collections.EMPTY_MAP);
        }
    }

    public String toString() {
        return TO_STRING + this.getURI().toString() + READ_COUNT_TO_STRING + new Integer(this.readReferenceCount) + WRITE_COUNT_TO_STRING + new Integer(this.editReferenceCount);
    }

    public boolean needsToSave() {
        return this.isModified() && !this.isSharedForWrite();
    }

    public void setForceRefresh(boolean b) {
        this.forceRefresh = b;
    }

    public boolean shouldForceRefresh() {
        return this.forceRefresh;
    }

    /*
     * Exception decompiling
     */
    protected void basicDoLoad(InputStream arg0, Map arg1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 44->48)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void doUnload() {
        if (this.isTrackingModification() && this.editReferenceCount < 1) {
            this.setTrackingModification(false);
        }
        super.doUnload();
        this.setForceRefresh(false);
        this.setModified(false);
        if (this.readReferenceCount == 0 && this.editReferenceCount == 0) {
            this.resetAsNew();
        }
    }

    private void resetAsNew() {
        this.readReferenceCount = 1;
        this.isNew = true;
    }

    public void save(Map options) throws IOException {
        super.save(options);
        this.notifySaved();
    }

    protected void notifySaved() {
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(601, this, this){

                public Object getNotifier() {
                    return ReferencedXMIResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 601;
                }
            };
            this.eNotify((Notification)notification);
        }
    }

    public boolean wasReverted() {
        return false;
    }
}

