/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.htmlcss;

import java.util.StringTokenizer;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSelectorAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSimpleSelector;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Element;

public class HTMLStyleSelectorAdapter
implements IStyleSelectorAdapter {
    private static HTMLStyleSelectorAdapter instance;
    private Object toMatch;
    static /* synthetic */ Class class$0;

    public HTMLStyleSelectorAdapter() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSelectorAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.toMatch = clazz;
    }

    public static synchronized HTMLStyleSelectorAdapter getInstance() {
        if (instance == null) {
            instance = new HTMLStyleSelectorAdapter();
        }
        return instance;
    }

    public boolean isAdapterForType(Object type) {
        return type == this.toMatch;
    }

    public boolean match(ICSSSimpleSelector selector, Element element, String pseudoName) {
        StringTokenizer tokenizer;
        String key;
        if (element == null) {
            return false;
        }
        int i = selector.getNumOfPseudoNames();
        if (i > 0) {
            if (pseudoName == null || pseudoName.length() == 0) {
                return false;
            }
            --i;
            while (i >= 0) {
                if (pseudoName.equalsIgnoreCase(selector.getPseudoName(i))) break;
                --i;
            }
            if (i < 0) {
                return false;
            }
        }
        if (!selector.isUniversal() && !element.getNodeName().equalsIgnoreCase(selector.getName())) {
            return false;
        }
        i = selector.getNumOfIDs();
        if (i > 0) {
            if (i > 1) {
                return false;
            }
            key = element.getAttribute("id");
            if (key == null) {
                return false;
            }
            if (!selector.getID(0).equals(key)) {
                return false;
            }
        }
        if ((i = selector.getNumOfClasses()) > 0) {
            key = element.getAttribute("class");
            if (key == null) {
                return false;
            }
            tokenizer = new StringTokenizer(key);
            --i;
            while (i >= 0) {
                boolean ok = false;
                while (tokenizer.hasMoreTokens()) {
                    if (!selector.getClass(i).equals(tokenizer.nextToken())) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    return false;
                }
                --i;
            }
        }
        i = selector.getNumOfAttributes() - 1;
        while (i >= 0) {
            tokenizer = new StringTokenizer(selector.getAttribute(i), "=~| \t\r\n\f");
            int countTokens = tokenizer.countTokens();
            if (countTokens > 0) {
                String attrValue = element.getAttribute(tokenizer.nextToken());
                if (attrValue == null) {
                    return false;
                }
                if (countTokens > 1) {
                    String token = tokenizer.nextToken("= \t\r\n\f");
                    StringTokenizer attrValueTokenizer = null;
                    if (token.equals("~")) {
                        attrValueTokenizer = new StringTokenizer(attrValue);
                    } else if (token.equals("|")) {
                        attrValueTokenizer = new StringTokenizer(attrValue, "-");
                    }
                    if (attrValueTokenizer != null) {
                        if (tokenizer.hasMoreTokens()) {
                            token = tokenizer.nextToken();
                            boolean ok = false;
                            while (attrValueTokenizer.hasMoreTokens()) {
                                if (!token.equals(attrValueTokenizer.nextToken())) continue;
                                ok = true;
                                break;
                            }
                            if (!ok) {
                                return false;
                            }
                        }
                    } else if (!attrValue.equals(token)) {
                        return false;
                    }
                }
            }
            --i;
        }
        return true;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }
}

