/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.model.internal.validation.ConnectorMessageConstants;
import org.eclipse.jst.j2ee.model.internal.validation.J2EEValidator;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ConnectorValidator
extends J2EEValidator
implements ConnectorMessageConstants {
    protected RARFile rarFile;
    protected Connector connectorDD;

    public String getBaseName() {
        return "rarvalidation";
    }

    protected Connector getConnectorDD() {
        return this.connectorDD;
    }

    protected void setConnectorDD(Connector connectorDD) {
        this.connectorDD = connectorDD;
    }

    protected RARFile getRarFile() {
        return this.rarFile;
    }

    protected void setRarFile(RARFile rarFile) {
        this.rarFile = rarFile;
    }

    public void validate(IValidationContext inHelper, IReporter inReporter) throws ValidationException {
        super.validate(inHelper, inReporter);
        this._reporter.removeAllMessages((IValidator)this, null);
        try {
            this.setRarFile((RARFile)inHelper.loadModel("CONNECTOR_VALIDATION"));
            if (this.rarFile == null) {
                Message errorMsg = new Message(this.getBaseName(), 1, "ERROR_INVALID_CONNECTOR_FILE");
                throw new ValidationException((IMessage)errorMsg);
            }
            this.setConnectorDD(this.rarFile.getDeploymentDescriptor());
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (Exception e) {
            Message errorMsg = new Message(this.getBaseName(), 1, "ERROR_CONNECTOR_VALIDATION_FAILED");
            throw new ValidationException((IMessage)errorMsg, (Throwable)e);
        }
    }

    protected void validateJ2EE14DocType() {
        if (this.getConnectorDD().getVersionID() < 15) {
            String[] params = new String[3];
            params[0] = "1.5";
            params[2] = "1.0";
            this.addError(this.getBaseName(), "CONNECTOR_INVALID_DOC_TYPE_ERROR_", params);
        } else if (this.getConnectorDD().getVersionID() != 10) {
            String[] params = new String[3];
            params[0] = "1.0";
            params[2] = "1.5";
            this.addError(this.getBaseName(), "CONNECTOR_INVALID_DOC_TYPE_ERROR_", params);
        }
    }
}

