/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ui.eclipse;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.command.internal.env.ui.dialog.MessageDialog;
import org.eclipse.wst.command.internal.provisional.env.core.common.Choice;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusException;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;

public class EclipseStatusHandler
implements StatusHandler {
    private Shell shell_;
    private MessageUtils msg_ = new MessageUtils("org.eclipse.wst.command.internal.env.common.environment", (Object)this);

    public EclipseStatusHandler() {
        this(new Shell());
    }

    public EclipseStatusHandler(Shell shell) {
        this.shell_ = shell;
    }

    public Choice report(Status status, Choice[] choices) {
        int result = MessageDialog.openMessage(this.shell_, this.msg_.getMessage("TITLE_WARNING"), null, status, choices);
        int i = 0;
        while (i < choices.length) {
            if (choices[i].getShortcut() == result) {
                return choices[i];
            }
            ++i;
        }
        return null;
    }

    public void report(Status status) throws StatusException {
        boolean userOk = false;
        switch (status.getSeverity()) {
            case 4: {
                userOk = this.reportErrorStatus(status);
                break;
            }
            case 2: {
                userOk = this.reportWarning(status);
                break;
            }
            case 1: {
                userOk = true;
                this.reportInfo(status);
            }
        }
        if (!userOk) {
            throw new StatusException(status);
        }
    }

    private boolean reportWarning(Status status) {
        int userResponse = MessageDialog.openMessage(this.shell_, this.msg_.getMessage("TITLE_WARNING"), null, status);
        return userResponse == 0;
    }

    private boolean reportErrorStatus(Status status) {
        MessageDialog.openMessage(this.shell_, this.msg_.getMessage("TITLE_ERROR"), null, status);
        return false;
    }

    public void reportError(Status status) {
        this.reportErrorStatus(status);
    }

    public void reportInfo(Status status) {
        MessageDialog.openMessage(this.shell_, this.msg_.getMessage("TITLE_INFO"), null, status);
    }
}

