/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.rdb.internal.outputview.OutputView;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;

public class OutputUtil {
    protected static IWorkbenchWindow activeWindow = null;
    protected static IWorkbenchPage activePage = null;
    protected static IViewPart viewPart = null;

    public static OutputView getOutputView() {
        return OutputUtil.getOutputView(false);
    }

    public static OutputView getOutputView(boolean async) {
        int i;
        if (activeWindow == null) {
            activeWindow = OutputViewPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow();
        }
        if (activeWindow == null) {
            IWorkbenchWindow[] ww = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (ww.length > 0) {
                activeWindow = ww[0];
                if (activeWindow == null) {
                    return null;
                }
            } else {
                return null;
            }
            activePage = activeWindow.getActivePage();
            if (activePage == null) {
                IWorkbenchPage[] pages = activeWindow.getPages();
                i = 0;
                while (i < pages.length) {
                    if (pages[i].getPerspective().getId().equals("com.ibm.datatools.core.internal.ui.perspective")) {
                        activePage = pages[i];
                    }
                    ++i;
                }
            }
        } else {
            activePage = activeWindow.getActivePage();
        }
        if (activePage == null) {
            return null;
        }
        if (async) {
            viewPart = null;
            Display display = activeWindow.getShell().getDisplay();
            if (display != null) {
                IViewReference[] viewReference = activePage.getViewReferences();
                i = 0;
                while (i < viewReference.length) {
                    viewPart = viewReference[i].getView(false);
                    if (viewPart instanceof OutputView) {
                        display.syncExec(new Runnable(){

                            public void run() {
                                activePage.bringToTop((IWorkbenchPart)viewPart);
                            }
                        });
                        return (OutputView)viewPart;
                    }
                    ++i;
                }
                display.syncExec(new Runnable(){

                    public void run() {
                        try {
                            viewPart = activePage.showView("org.eclipse.wst.rdb.internal.outputview.OutputView");
                        }
                        catch (PartInitException e) {
                            MessageDialog.openError((Shell)new Shell(), (String)OutputViewPlugin.getString("STR_OPEN_OUTPUT_ERROR"), (String)e.getMessage());
                            OutputViewPlugin.getPlugin().writeLog(4, 0, "OutputView:getOutputView.", e);
                            viewPart = null;
                        }
                    }
                });
                if (viewPart != null) {
                    return (OutputView)viewPart;
                }
                return null;
            }
            return null;
        }
        IViewReference[] viewReference = activePage.getViewReferences();
        int i2 = 0;
        while (i2 < viewReference.length) {
            viewPart = viewReference[i2].getView(false);
            if (viewPart instanceof OutputView) {
                activePage.bringToTop((IWorkbenchPart)viewPart);
                return (OutputView)viewPart;
            }
            ++i2;
        }
        try {
            viewPart = activePage.showView("org.eclipse.wst.rdb.internal.outputview.OutputView");
            return (OutputView)viewPart;
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)new Shell(), (String)OutputViewPlugin.getString("STR_OPEN_OUTPUT_ERROR"), (String)e.getMessage());
            OutputViewPlugin.getPlugin().writeLog(4, 0, "OutputView:getOutputView.", e);
            return null;
        }
    }
}

