/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.derby.ddl;

import java.util.Iterator;
import org.eclipse.wst.rdb.internal.core.rte.fe.GenericDdlBuilder;
import org.eclipse.wst.rdb.internal.models.sql.expressions.ValueExpression;
import org.eclipse.wst.rdb.internal.models.sql.routines.Parameter;
import org.eclipse.wst.rdb.internal.models.sql.routines.ParameterMode;
import org.eclipse.wst.rdb.internal.models.sql.routines.Procedure;
import org.eclipse.wst.rdb.internal.models.sql.routines.Routine;
import org.eclipse.wst.rdb.internal.models.sql.routines.RoutineResultTable;
import org.eclipse.wst.rdb.internal.models.sql.routines.Source;
import org.eclipse.wst.rdb.internal.models.sql.routines.UserDefinedFunction;
import org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier;
import org.eclipse.wst.rdb.internal.models.sql.schema.TypedElement;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;

public class DerbyDdlBuilder
extends GenericDdlBuilder {
    protected static final String IN = "IN";
    protected static final String OUT = "OUT";
    protected static final String INOUT = "INOUT";
    protected static final String LOCATOR = "LOCATOR";
    protected static final String EXTERNAL = "EXTERNAL";
    protected static final String RETURNS = "RETURNS";
    protected static final String CAST = "CAST";
    protected static final String FROM = "FROM";
    protected static final String COMMENT = "COMMENT";
    protected static final String IS = "IS";
    protected static final String COLUMN = "COLUMN";

    public String createProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        procedure.getSchema().getDatabase();
        String text = "CREATE PROCEDURE " + this.getName((Routine)procedure, quoteIdentifiers, qualifyNames) + " " + "(" + this.getParameters((Routine)procedure) + ")";
        text = String.valueOf(text) + NEWLINE + "\t" + "LANGUAGE " + procedure.getLanguage();
        text = String.valueOf(text) + this.getExternalNameOption((Routine)procedure, quoteIdentifiers, qualifyNames);
        text = String.valueOf(text) + this.getParameterStyleOption((Routine)procedure);
        return text;
    }

    public String createUserDefinedFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        function.getSchema().getDatabase();
        String text = "CREATE FUNCTION " + this.getName((Routine)function, quoteIdentifiers, qualifyNames);
        Source source = function.getSource();
        if (source != null) {
            text = String.valueOf(text) + source.getBody();
        }
        text = String.valueOf(text) + this.getExternalNameOption((Routine)function, quoteIdentifiers, qualifyNames);
        return text;
    }

    public String dropProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        procedure.getSchema().getDatabase();
        return "DROP PROCEDURE " + this.getName((Routine)procedure, quoteIdentifiers, qualifyNames);
    }

    public String dropFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        function.getSchema().getDatabase();
        return "DROP FUNCTION " + this.getName((Routine)function, quoteIdentifiers, qualifyNames);
    }

    protected String getColumnString(Column column, boolean quoteIdentifiers) {
        String columnDefinition = super.getColumnString(column, quoteIdentifiers);
        IdentitySpecifier spec = column.getIdentitySpecifier();
        ValueExpression v = column.getGenerateExpression();
        if (spec != null) {
            columnDefinition = String.valueOf(columnDefinition) + " GENERATED ALWAYS AS IDENTITY ";
            columnDefinition = String.valueOf(columnDefinition) + " (" + this.getIdentityString(spec) + ")";
        } else if (v != null) {
            columnDefinition = String.valueOf(columnDefinition) + " GENERATED ALWAYS AS " + v.getSQL();
        }
        return columnDefinition;
    }

    protected String getIdentityString(IdentitySpecifier identitySpecifier) {
        String clause = "START WITH " + identitySpecifier.getStartValue() + " ,INCREMENT BY " + identitySpecifier.getIncrement();
        return clause;
    }

    protected String getParameters(Routine routine) {
        String parameters = "";
        Iterator it = routine.getParameters().iterator();
        while (it.hasNext()) {
            Parameter p = (Parameter)it.next();
            ParameterMode mode = p.getMode();
            if (mode == ParameterMode.INOUT_LITERAL) {
                parameters = String.valueOf(parameters) + "INOUT ";
            } else if (mode == ParameterMode.OUT_LITERAL) {
                parameters = String.valueOf(parameters) + "OUT ";
            }
            String name = p.getName();
            if (name != null && name.length() != 0) {
                parameters = String.valueOf(parameters) + p.getName() + " ";
            }
            parameters = String.valueOf(parameters) + this.getDataTypeString((TypedElement)p, routine.getSchema());
            if (p.isLocator()) {
                parameters = String.valueOf(parameters) + " AS LOCATOR";
            }
            if (!it.hasNext()) continue;
            parameters = String.valueOf(parameters) + "," + NEWLINE + "\t" + "\t";
        }
        return parameters;
    }

    protected String getExternalNameOption(Routine routine, boolean quoteIdentifiers, boolean qualifyNames) {
        String option = String.valueOf(NEWLINE) + "\t" + EXTERNAL;
        String externalName = routine.getExternalName();
        if (externalName != null && externalName.length() != 0) {
            String schemaName = routine.getSchema().getName();
            if (routine.getLanguage().equalsIgnoreCase("JAVA")) {
                externalName = this.getSingleQuotedString(externalName);
            } else {
                if (quoteIdentifiers) {
                    externalName = this.getDoubleQuotedString(externalName);
                    schemaName = this.getDoubleQuotedString(schemaName);
                }
                if (qualifyNames) {
                    externalName = String.valueOf(schemaName) + "." + externalName;
                }
            }
            option = String.valueOf(option) + " NAME " + externalName;
        }
        return option;
    }

    protected String getParameterStyleOption(Routine routine) {
        return String.valueOf(NEWLINE) + "\t" + "PARAMETER STYLE " + routine.getParameterStyle();
    }

    protected String getFunctionReturnsClause(UserDefinedFunction function) {
        if (function.getReturnScaler() != null) {
            Parameter scaler = function.getReturnScaler();
            String text = "RETURNS " + this.getDataTypeString((TypedElement)scaler, function.getSchema());
            if (function.getReturnCast() != null) {
                Parameter cast = function.getReturnCast();
                text = String.valueOf(text) + " CAST FROM " + this.getDataTypeString((TypedElement)cast, function.getSchema());
            }
            return text;
        }
        if (function.getReturnTable() != null) {
            RoutineResultTable resultTable = function.getReturnTable();
            String text = "RETURNS TABLE (";
            Iterator it = resultTable.getColumns().iterator();
            while (it.hasNext()) {
                Column c = (Column)it.next();
                text = String.valueOf(text) + c.getName() + " " + this.getDataTypeString((TypedElement)c, function.getSchema());
                if (!it.hasNext()) continue;
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + ")";
            return text;
        }
        Parameter parameter = function.getReturnCast();
        if (parameter != null) {
            return parameter.getName();
        }
        return null;
    }
}

