/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.operation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class CreateReferenceComponentsOp
extends AbstractDataModelOperation {
    public CreateReferenceComponentsOp(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.addReferencedComponents(monitor);
        this.addProjectReferences();
        return OK_STATUS;
    }

    private void addProjectReferences() {
        ComponentHandle handle = (ComponentHandle)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT_HANDLE");
        IProject sourceProject = handle.getProject();
        List modList = (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_HANDLE_LIST");
        ArrayList<IProject> targetprojectList = new ArrayList<IProject>();
        int i = 0;
        while (i < modList.size()) {
            ComponentHandle targethandle = (ComponentHandle)modList.get(i);
            IProject targetProject = targethandle.getProject();
            targetprojectList.add(targetProject);
            ++i;
        }
        try {
            ProjectUtilities.addReferenceProjects((IProject)sourceProject, targetprojectList);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void addReferencedComponents(IProgressMonitor monitor) {
        ComponentHandle sourceHandle = (ComponentHandle)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT_HANDLE");
        IVirtualComponent sourceComp = ComponentCore.createComponent(sourceHandle.getProject(), sourceHandle.getName());
        ArrayList<IVirtualReference> vlist = new ArrayList<IVirtualReference>();
        IVirtualReference[] oldrefs = sourceComp.getReferences();
        int i = 0;
        while (i < oldrefs.length) {
            IVirtualReference ref = oldrefs[i];
            vlist.add(ref);
            ++i;
        }
        List modList = (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_HANDLE_LIST");
        int i2 = 0;
        while (i2 < modList.size()) {
            ComponentHandle handle = (ComponentHandle)modList.get(i2);
            IVirtualComponent comp = ComponentCore.createComponent(handle.getProject(), handle.getName());
            if (!this.srcComponentContainsReference(sourceComp, comp)) {
                IVirtualReference ref = ComponentCore.createReference(sourceComp, comp);
                String deployPath = this.model.getStringProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH");
                if (deployPath != null && deployPath.length() > 0) {
                    ref.setRuntimePath((IPath)new Path(deployPath));
                }
                vlist.add(ref);
            }
            ++i2;
        }
        IVirtualReference[] refs = new IVirtualReference[vlist.size()];
        int i3 = 0;
        while (i3 < vlist.size()) {
            IVirtualReference ref;
            refs[i3] = ref = (IVirtualReference)vlist.get(i3);
            ++i3;
        }
        sourceComp.setReferences(refs);
    }

    private boolean srcComponentContainsReference(IVirtualComponent sourceComp, IVirtualComponent comp) {
        IVirtualReference[] existingReferences = sourceComp.getReferences();
        int i = 0;
        while (i < existingReferences.length) {
            if (existingReferences[i].getReferencedComponent().getName().equals(comp.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

