/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.operation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditOperation;
import org.eclipse.wst.common.componentcore.resources.IFlexibleProject;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public abstract class ArtifactEditOperationDataModel
extends WTPOperationDataModel {
    public static final String PROJECT_NAME = "ArtifactEditOperationDataModel.PROJECT_NAME";
    public static final String MODULE_NAME = "ArtifactEditOperationDataModel.MODULE_NAME";
    public static final String PROMPT_ON_SAVE = "ArtifactEditOperationDataModel.PROMPT_ON_SAVE";
    private IVirtualComponent comp = null;

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(PROJECT_NAME);
        this.addValidBaseProperty(MODULE_NAME);
        this.addValidBaseProperty(PROMPT_ON_SAVE);
    }

    public IProject getTargetProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getStringProperty(PROJECT_NAME));
    }

    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(PROMPT_ON_SAVE)) {
            return Boolean.FALSE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public WTPOperation getDefaultOperation() {
        return new ArtifactEditOperation(this);
    }

    public ArtifactEdit getArtifactEditForRead() {
        return ArtifactEdit.getArtifactEditForRead(this.getComponent());
    }

    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean status = super.doSetProperty(propertyName, propertyValue);
        if (MODULE_NAME.equals(propertyName)) {
            this.comp = null;
            IProject proj = this.getComponent().getProject();
            if (proj != null) {
                this.setProperty(PROJECT_NAME, proj.getName());
            }
        }
        return status;
    }

    public IVirtualComponent getComponent() {
        IProject project;
        if (this.comp == null && (project = this.getTargetProject()).exists() && project.isAccessible()) {
            IFlexibleProject flex = ComponentCore.createFlexibleProject(project);
            if (this.getProperty(MODULE_NAME) != null) {
                this.comp = flex.getComponent(this.getStringProperty(MODULE_NAME));
            }
        }
        return this.comp;
    }

    protected IStatus doValidateProperty(String propertyName) {
        IStatus result = super.doValidateProperty(propertyName);
        if (!result.isOK()) {
            return result;
        }
        if (propertyName.equals(PROJECT_NAME)) {
            return this.validateProjectName();
        }
        if (propertyName.equals(MODULE_NAME)) {
            return this.validateModuleName();
        }
        return result;
    }

    protected IStatus validateProjectName() {
        String projectName = this.getStringProperty(PROJECT_NAME);
        if (projectName == null || projectName.length() == 0) {
            return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"15"));
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    protected IStatus validateModuleName() {
        String moduleName = this.getStringProperty(MODULE_NAME);
        if (moduleName == null || moduleName.length() == 0) {
            return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"34"));
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

