/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.impl;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;

public class ModuleURIUtil {
    protected static final String RESOURCE_URI_PROTOCOL = "module:/resource/";
    protected static final String ARCHIVE_URI_PROTOCOL = "module:/classpath/";
    public static final String PLATFORM_SCHEME = "platform";
    public static final String RESOURCE_PROTOCOL = "resource";

    public static String getDeployedName(URI aModuleURI) throws UnresolveableURIException {
        ModuleURIUtil.ensureValidFullyQualifiedModuleURI(aModuleURI);
        return aModuleURI.segment(2);
    }

    public static boolean ensureValidFullyQualifiedModuleURI(URI aModuleURI) throws UnresolveableURIException {
        return ModuleURIUtil.ensureValidFullyQualifiedModuleURI(aModuleURI, true);
    }

    public static boolean ensureValidFullyQualifiedModuleURI(URI aModuleURI, boolean toThrowExceptionIfNecessary) throws UnresolveableURIException {
        if (aModuleURI.segmentCount() < 3) {
            if (toThrowExceptionIfNecessary) {
                throw new UnresolveableURIException(aModuleURI);
            }
            return false;
        }
        return true;
    }

    public static boolean ensureValidFullyQualifiedPlatformURI(URI aFullyQualifiedResourceURI, boolean toThrowExceptionIfNecessary) throws UnresolveableURIException {
        if (aFullyQualifiedResourceURI.segmentCount() < 2 || !PLATFORM_SCHEME.equals(aFullyQualifiedResourceURI.scheme()) || !RESOURCE_PROTOCOL.equals(aFullyQualifiedResourceURI.segment(0))) {
            if (toThrowExceptionIfNecessary) {
                throw new UnresolveableURIException(aFullyQualifiedResourceURI);
            }
            return false;
        }
        return true;
    }

    public static void ensureValidFullyQualifiedPlatformURI(URI aFullyQualifiedResourceURI) throws UnresolveableURIException {
        ModuleURIUtil.ensureValidFullyQualifiedPlatformURI(aFullyQualifiedResourceURI, true);
    }

    public static URI trimModuleResourcePathToModuleURI(URI aModuleResourcePath) throws UnresolveableURIException {
        ModuleURIUtil.ensureValidFullyQualifiedModuleURI(aModuleResourcePath);
        return aModuleResourcePath.trimSegments(aModuleResourcePath.segmentCount() - 3);
    }

    public static URI trimWorkspacePathToProjectRelativeURI(URI aFullyQualifiedResourceURI) throws UnresolveableURIException {
        URI projectRelativePath = null;
        if (ModuleURIUtil.ensureValidFullyQualifiedPlatformURI(aFullyQualifiedResourceURI, false)) {
            if (aFullyQualifiedResourceURI.segmentCount() == 2) {
                return URI.createURI((String)"");
            }
            projectRelativePath = ModuleURIUtil.trimToRelativePath(aFullyQualifiedResourceURI, 2);
        } else if (aFullyQualifiedResourceURI.isHierarchical() && aFullyQualifiedResourceURI.path().startsWith("/")) {
            projectRelativePath = ModuleURIUtil.trimToRelativePath(aFullyQualifiedResourceURI, 1);
        } else {
            throw new UnresolveableURIException(aFullyQualifiedResourceURI);
        }
        return projectRelativePath;
    }

    public static URI trimToRelativePath(URI aURI, int aStartIndex) {
        StringBuffer relativePath = new StringBuffer();
        int segmentIndex = aStartIndex;
        while (segmentIndex < aURI.segmentCount()) {
            relativePath.append(aURI.segment(segmentIndex));
            if (segmentIndex < aURI.segmentCount() - 1) {
                relativePath.append('/');
            }
            ++segmentIndex;
        }
        return URI.createURI((String)relativePath.toString());
    }

    public static URI trimToDeployPathSegment(URI aFullyQualifiedModuleResourcePath) {
        int segmentCount = aFullyQualifiedModuleResourcePath.segmentCount();
        return aFullyQualifiedModuleResourcePath.deresolve(aFullyQualifiedModuleResourcePath.trimSegments(segmentCount - 4));
    }

    public static URI concat(URI uri1, URI uri2) {
        URI concatURI = uri1.appendSegments(uri2.segments());
        return concatURI;
    }

    public static URI fullyQualifyURI(WorkbenchComponent aComponent) {
        try {
            if (ModuleURIUtil.ensureValidFullyQualifiedModuleURI(aComponent.getHandle(), false)) {
                return aComponent.getHandle();
            }
            IProject project = StructureEdit.getContainingProject(aComponent);
            if (project != null) {
                return URI.createURI((String)(RESOURCE_URI_PROTOCOL + project.getName() + '/' + aComponent.getName()));
            }
        }
        catch (UnresolveableURIException unresolveableURIException) {}
        return null;
    }

    public static URI fullyQualifyURI(IProject aProject, String aComponentName) {
        return URI.createURI((String)(RESOURCE_URI_PROTOCOL + aProject.getName() + '/' + aComponentName));
    }

    public static URI archiveComponentfullyQualifyURI(String aComponentName) {
        return URI.createURI((String)(ARCHIVE_URI_PROTOCOL + aComponentName));
    }

    public static URI fullyQualifyURI(ComponentHandle aHandle) {
        return ModuleURIUtil.fullyQualifyURI(aHandle.getProject(), aHandle.getName());
    }

    public static boolean isClassPathURI(URI uri) {
        return "classpath".equals(uri.segment(0));
    }

    public static String getArchiveType(URI aModuleURI) throws UnresolveableURIException {
        ModuleURIUtil.ensureValidFullyQualifiedModuleURI(aModuleURI);
        return aModuleURI.segment(1);
    }

    public static String getArchiveName(URI aModuleURI) throws UnresolveableURIException {
        ModuleURIUtil.ensureValidFullyQualifiedModuleURI(aModuleURI);
        URI uri = ModuleURIUtil.trimToRelativePath(aModuleURI, 2);
        return uri.toString();
    }

    public static interface ModuleURI {
        public static final int SUB_PROTOCOL_INDX = 0;
        public static final int PROJECT_NAME_INDX = 1;
        public static final int MODULE_NAME_INDX = 2;
    }
}

