/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.builder;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.common.componentcore.datamodel.properties.IWorkbenchComponentBuilderDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.enablement.DataModelEnablementFactory;

public abstract class WorkbenchComponentBuilderDataModelProvider
extends AbstractDataModelProvider
implements IWorkbenchComponentBuilderDataModelProperties {
    public String[] getPropertyNames() {
        return new String[]{"IWorkbenchComponentBuilderDataModelProperties.OUTPUT_CONTAINER", "IWorkbenchComponentBuilderDataModelProperties.VIRTUAL_COMPONENT", "IWorkbenchComponentBuilderDataModelProperties.DEPENDENT_COMPONENT_DM_LIST", "IWorkbenchComponentBuilderDataModelProperties.BUILD_KIND_FOR_DEP"};
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IWorkbenchComponentBuilderDataModelProperties.VIRTUAL_COMPONENT")) {
            this.model.setProperty("IWorkbenchComponentBuilderDataModelProperties.OUTPUT_CONTAINER", this.populateOutputContainer());
            this.model.setProperty("IWorkbenchComponentBuilderDataModelProperties.DEPENDENT_COMPONENT_DM_LIST", this.populateDependentModulesDM());
        }
        return true;
    }

    private Object populateDependentModulesDM() {
        IVirtualComponent vComponent = (IVirtualComponent)this.model.getProperty("IWorkbenchComponentBuilderDataModelProperties.VIRTUAL_COMPONENT");
        IVirtualReference[] vReferences = vComponent.getReferences();
        ArrayList<IDataModel> depModulesDataModels = new ArrayList<IDataModel>(vReferences.length);
        IDataModel dependentDataModel = null;
        IProject project = vComponent.getProject();
        this.model.getProperty("IWorkbenchComponentBuilderDataModelProperties.OUTPUT_CONTAINER");
        int i = 0;
        while (i < vReferences.length) {
            dependentDataModel = DataModelEnablementFactory.createDataModel((String)"dependent.builder", (IProject)project);
            if (dependentDataModel != null) {
                dependentDataModel.setProperty("IReferencedComponentBuilderDataModelProperties.VIRTUAL_REFERENCE", (Object)vReferences[i]);
                depModulesDataModels.add(dependentDataModel);
            }
            ++i;
        }
        return depModulesDataModels;
    }

    private Object populateOutputContainer() {
        IVirtualComponent vComponent = (IVirtualComponent)this.model.getProperty("IWorkbenchComponentBuilderDataModelProperties.VIRTUAL_COMPONENT");
        IFolder outputContainer = null;
        if (vComponent != null) {
            outputContainer = StructureEdit.getOutputContainerRoot(vComponent);
        }
        return outputContainer;
    }

    public abstract IDataModelOperation getDefaultOperation();
}

