/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.builder;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.datamodel.properties.IReferencedComponentBuilderDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.builder.ComponentStructuralBuilder;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.util.ZipFileExporter;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ReferencedComponentBuilderOperation
extends AbstractDataModelOperation
implements IReferencedComponentBuilderDataModelProperties {
    private static String ERROR_EXPORTING_MSG = "Zip Error Message";
    private ZipFileExporter exporter = null;
    private List errorTable = new ArrayList(1);
    private boolean useCompression = true;
    private boolean generateManifestFile = false;
    private IProgressMonitor monitor;
    private int inputContainerSegmentCount;

    public ReferencedComponentBuilderOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        try {
            this.monitor = monitor;
            IVirtualReference vReference = (IVirtualReference)this.model.getProperty("IReferencedComponentBuilderDataModelProperties.VIRTUAL_REFERENCE");
            vReference.getEnclosingComponent();
            IPath absoluteOutputContainer = this.getAbsoluteOutputContainer(vReference);
            if (absoluteOutputContainer == null) {
                return OK_STATUS;
            }
            IFolder outputContainerFolder = this.createFolder(absoluteOutputContainer);
            IVirtualComponent referencedComponent = vReference.getReferencedComponent();
            IPath absoluteInputContainer = this.getAbsoluteInputContainer(referencedComponent);
            if (absoluteOutputContainer == null) {
                return OK_STATUS;
            }
            if ((absoluteInputContainer == null || !referencedComponent.getProject().getFolder(absoluteInputContainer).exists()) && vReference.getReferencedComponent().isBinary()) {
                try {
                    String osPath = "";
                    VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)referencedComponent;
                    if (archiveComp.getArchiveType().equals("var")) {
                        IPath resolvedpath = (IPath)archiveComp.getAdapter(VirtualArchiveComponent.ADAPTER_TYPE);
                        osPath = resolvedpath.toOSString();
                    } else {
                        String fileString = ModuleURIUtil.getArchiveName(URI.createURI((String)referencedComponent.getComponentHandle().toString()));
                        Path path = new Path(fileString);
                        osPath = path.toOSString();
                    }
                    if (vReference.getDependencyType() == 1) {
                        this.expandZipFile(osPath, outputContainerFolder);
                    } else {
                        this.copyFile(osPath, outputContainerFolder);
                    }
                    return OK_STATUS;
                }
                catch (UnresolveableURIException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
            if (vReference.getDependencyType() == 1) {
                IResource sourceResource = this.getResource(absoluteInputContainer);
                if (sourceResource == null) {
                    return OK_STATUS;
                }
                ComponentStructuralBuilder.smartCopy(sourceResource, absoluteOutputContainer, new NullProgressMonitor());
            } else {
                String zipName = this.getZipFileName(referencedComponent);
                IPath zipNameDestination = absoluteOutputContainer.append(zipName);
                IResource dependentZip = this.getResource(zipNameDestination);
                if (dependentZip == null || dependentZip.exists()) {
                    return OK_STATUS;
                }
                this.zipAndCopyResource(this.getResource(absoluteInputContainer), dependentZip);
                this.getResource(absoluteOutputContainer).refreshLocal(2, monitor);
            }
        }
        catch (CoreException ex) {
            Logger.getLogger().log((Object)ex.getMessage());
        }
        return OK_STATUS;
    }

    /*
     * Exception decompiling
     */
    private void copyFile(String osPath, IFolder outputContainerFolder) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 146->150)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void expandZipFile(String filePath, IFolder absoluteOutputContainer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [2 : 155->158)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
        return null;
    }

    private void zipAndCopyResource(IResource inputResource, IResource outputResource) {
        try {
            if (inputResource.exists()) {
                IResource[] children = ((IContainer)inputResource).members();
                if (children.length == 0) {
                    Logger.getLogger().log((Object)("Warning: Unable to zip empty archive from directory: " + inputResource.getName()));
                    return;
                }
            } else {
                Logger.getLogger().log((Object)("Warning: Unable to zip empty archive from directory: " + inputResource.getName()));
                return;
            }
            String osPath = outputResource.getLocation().toOSString();
            this.exporter = new ZipFileExporter(osPath, true);
            this.inputContainerSegmentCount = inputResource.getFullPath().segmentCount();
            this.exportResource(inputResource);
            this.exporter.finished();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
        catch (InterruptedException iEx) {
            iEx.printStackTrace();
        }
    }

    private IPath getAbsoluteOutputContainer(IVirtualReference vReference) {
        IVirtualComponent vComponent = vReference.getEnclosingComponent();
        IFolder localWorkbenchModuleOuptutContainer = null;
        localWorkbenchModuleOuptutContainer = StructureEdit.getOutputContainerRoot(vComponent);
        if (localWorkbenchModuleOuptutContainer == null) {
            return null;
        }
        IPath localWorkbenchModuleOuptutContainerPath = localWorkbenchModuleOuptutContainer.getFullPath();
        return localWorkbenchModuleOuptutContainerPath.append(vReference.getRuntimePath().toString());
    }

    private IPath getAbsoluteInputContainer(IVirtualComponent virtualComponent) {
        return StructureEdit.getOutputContainerRoot(virtualComponent).getFullPath();
    }

    private String getZipFileName(IVirtualComponent vComponent) {
        String typeID = vComponent.getComponentTypeId();
        String zipFileName = vComponent.getName();
        zipFileName = zipFileName.replace('.', '_');
        if (typeID == null) {
            return zipFileName;
        }
        if (typeID.equals("jst.appclient") || typeID.equals("jst.ejb") || typeID.equals("jst.utility")) {
            return String.valueOf(zipFileName) + ".jar";
        }
        if (typeID.equals("jst.web")) {
            return String.valueOf(zipFileName) + ".war";
        }
        if (typeID.equals("jst.connector")) {
            return String.valueOf(zipFileName) + ".rar";
        }
        if (typeID.equals("jst.ear")) {
            return String.valueOf(zipFileName) + ".ear";
        }
        return zipFileName;
    }

    private IResource getResource(IPath absolutePath) throws CoreException {
        IFolder resource = null;
        if (!(absolutePath == null || absolutePath.isEmpty() || (resource = ResourcesPlugin.getWorkspace().getRoot().getFolder(absolutePath)) != null && resource instanceof IFolder)) {
            resource = ResourcesPlugin.getWorkspace().getRoot().getFile(absolutePath);
        }
        return resource;
    }

    public IFolder createFolder(IPath absolutePath) throws CoreException {
        if (absolutePath == null || absolutePath.isEmpty()) {
            return null;
        }
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(absolutePath);
        IContainer parent = folder.getParent();
        if (parent != null && !parent.exists() && parent instanceof IFolder) {
            this.createFolder(parent.getFullPath());
        }
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        return folder;
    }

    protected boolean exportResource(IResource resource) throws InterruptedException {
        if (!resource.isAccessible()) {
            return false;
        }
        if (resource.getType() == 1) {
            return this.writeResource(resource);
        }
        IResource[] children = null;
        try {
            children = ((IContainer)resource).members();
        }
        catch (CoreException e) {
            this.addError(this.format(ERROR_EXPORTING_MSG, new Object[]{resource.getFullPath()}), e);
        }
        boolean writeFolder = true;
        int i = 0;
        while (i < children.length) {
            writeFolder = !this.exportResource(children[i]) && writeFolder;
            ++i;
        }
        if (writeFolder) {
            this.writeResource(resource);
        }
        return true;
    }

    private boolean writeResource(IResource resource) throws InterruptedException {
        IPath fullPath = resource.getFullPath();
        String destinationName = fullPath.removeFirstSegments(this.inputContainerSegmentCount).toString();
        this.monitor.subTask(destinationName);
        try {
            if (resource.getType() == 1) {
                this.exporter.write((IFile)resource, destinationName);
            } else {
                this.exporter.writeFolder(destinationName);
            }
        }
        catch (IOException e) {
            this.addError(this.format(ERROR_EXPORTING_MSG, new Object[]{resource.getFullPath().makeRelative(), e.getMessage()}), e);
            return false;
        }
        catch (CoreException e) {
            this.addError(this.format(ERROR_EXPORTING_MSG, new Object[]{resource.getFullPath().makeRelative(), e.getMessage()}), e);
            return false;
        }
        this.monitor.worked(1);
        return true;
    }

    private String format(String pattern, Object[] arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    protected void addError(String message, Throwable e) {
        this.errorTable.add(new Status(4, "org.eclipse.wst.common.emfworkbench.integration", 0, message, e));
    }
}

