/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.datamodel.properties.IProjectComponentsBuilderDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.ComponentType;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.builder.DependencyGraphManager;
import org.eclipse.wst.common.componentcore.internal.builder.ProjectComponentsBuilderOperation;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.enablement.DataModelEnablementFactory;

public class ProjectComponentsBuilderDataModelProvider
extends AbstractDataModelProvider
implements IProjectComponentsBuilderDataModelProperties {
    public String[] getPropertyNames() {
        return new String[]{"IProjectComponentsBuilderDataModelProperties.PROJECT", "IProjectComponentsBuilderDataModelProperties.BUILD_KIND", "IProjectComponentsBuilderDataModelProperties.PROJECT_DETLA", "IProjectComponentsBuilderDataModelProperties.CHANGED_RESOURCES_DELTA", "IProjectComponentsBuilderDataModelProperties.ADDITIONAL_DEPENDENT_BUILDER_DM_LIST", "IProjectComponentsBuilderDataModelProperties.COMPONENT_CORE", "IProjectComponentsBuilderDataModelProperties.COMPONENT_BUILDER_DM_LIST"};
    }

    public void init() {
        super.init();
        this.model.setProperty("IProjectComponentsBuilderDataModelProperties.ADDITIONAL_DEPENDENT_BUILDER_DM_LIST", new ArrayList());
        this.model.setIntProperty("IProjectComponentsBuilderDataModelProperties.BUILD_KIND", 6);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("IProjectComponentsBuilderDataModelProperties.PROJECT".equals(propertyName)) {
            this.model.setProperty("IProjectComponentsBuilderDataModelProperties.COMPONENT_BUILDER_DM_LIST", this.populateModuleBuilderDataModelList());
            if (this.model.getIntProperty("IProjectComponentsBuilderDataModelProperties.BUILD_KIND") == 10 && this.model.isPropertySet("IProjectComponentsBuilderDataModelProperties.CHANGED_RESOURCES_DELTA")) {
                this.createAdditionalBuildersIfNecessary();
            }
        }
        return true;
    }

    private Object populateModuleBuilderDataModelList() {
        List moduleDMList = null;
        switch (this.model.getIntProperty("IProjectComponentsBuilderDataModelProperties.BUILD_KIND")) {
            case 6: 
            case 15: {
                moduleDMList = this.populateFullModuleBuilderDataModelList();
                break;
            }
            case 10: {
                moduleDMList = this.populateDeltaModuleBuilderDataModelList((ResourceDelta)this.getProperty("IProjectComponentsBuilderDataModelProperties.PROJECT_DETLA"));
                break;
            }
            default: {
                moduleDMList = this.populateFullModuleBuilderDataModelList();
            }
        }
        return moduleDMList;
    }

    private void createAdditionalBuildersIfNecessary() {
        List deltaResources = (List)this.model.getProperty("IProjectComponentsBuilderDataModelProperties.CHANGED_RESOURCES_DELTA");
        IVirtualResource[] vResources = null;
        int i = 0;
        while (i < deltaResources.size()) {
            vResources = ComponentCore.createResources((IResource)deltaResources.get(i));
            this.createAdditionalBuildersForVResoures(vResources);
            ++i;
        }
    }

    private void createAdditionalBuildersForVResoures(IVirtualResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            IVirtualComponent vReferencedComponent = resources[i].getComponent();
            ComponentHandle referencedComponentHandle = ComponentHandle.create(vReferencedComponent.getProject(), vReferencedComponent.getName());
            ComponentHandle[] referencingComponentHandles = DependencyGraphManager.getInstance().getDependencyGraph().getReferencingComponents(referencedComponentHandle);
            int j = 0;
            while (j < referencingComponentHandles.length) {
                IVirtualComponent vReferencingComponent = ComponentCore.createComponent(referencingComponentHandles[j].getProject(), referencingComponentHandles[j].getName());
                this.createAdditionalReferencedBuilders(vReferencingComponent, vReferencedComponent);
                ++j;
            }
            ++i;
        }
    }

    private void createAdditionalReferencedBuilders(IVirtualComponent containingComponent, IVirtualComponent depComponent) {
        List depModulesDataModels = (List)this.model.getProperty("IProjectComponentsBuilderDataModelProperties.ADDITIONAL_DEPENDENT_BUILDER_DM_LIST");
        IDataModel dependentDataModel = null;
        StructureEdit cfr_ignored_0 = (StructureEdit)this.model.getProperty("IProjectComponentsBuilderDataModelProperties.COMPONENT_CORE");
        IProject project = (IProject)this.model.getProperty("IProjectComponentsBuilderDataModelProperties.PROJECT");
        dependentDataModel = DataModelEnablementFactory.createDataModel((String)"dependent.builder", (IProject)project);
        if (dependentDataModel != null) {
            IVirtualReference virtualReference = ComponentCore.createReference(containingComponent, depComponent);
            dependentDataModel.setProperty("IReferencedComponentBuilderDataModelProperties.VIRTUAL_REFERENCE", (Object)virtualReference);
            depModulesDataModels.add(dependentDataModel);
        }
        this.model.setProperty("IProjectComponentsBuilderDataModelProperties.ADDITIONAL_DEPENDENT_BUILDER_DM_LIST", (Object)depModulesDataModels);
    }

    private List computeModuleBuildOrder(WorkbenchComponent wbModule, List sortedModuleList, List wbModuleList, Stack callStack) throws UnresolveableURIException {
        block7: {
            List list;
            if (callStack.contains(wbModule)) {
                throw new RuntimeException("Cyclical module dependency detected.");
            }
            try {
                callStack.push(wbModule);
                EList depModules = wbModule.getReferencedComponents();
                int i = 0;
                while (i < depModules.size()) {
                    WorkbenchComponent depWBModule;
                    ReferencedComponent depModule = (ReferencedComponent)depModules.get(i);
                    if (((StructureEdit)this.model.getProperty("IProjectComponentsBuilderDataModelProperties.COMPONENT_CORE")).isLocalDependency(depModule) && !sortedModuleList.contains(depWBModule = ((StructureEdit)this.model.getProperty("IProjectComponentsBuilderDataModelProperties.COMPONENT_CORE")).findComponentByURI(depModule.getHandle()))) {
                        this.computeModuleBuildOrder(depWBModule, sortedModuleList, null, callStack);
                    }
                    ++i;
                }
                if (!sortedModuleList.contains(wbModule)) {
                    sortedModuleList.add(wbModule);
                }
                if (wbModuleList == null || wbModuleList.isEmpty()) break block7;
                wbModule = (WorkbenchComponent)wbModuleList.remove(wbModuleList.size() - 1);
                list = this.computeModuleBuildOrder(wbModule, sortedModuleList, wbModuleList, callStack);
                Object var9_11 = null;
                callStack.pop();
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                callStack.pop();
                throw throwable;
            }
            return list;
        }
        List list = sortedModuleList;
        Object var9_12 = null;
        callStack.pop();
        return list;
    }

    private List computeModuleBuildOrder(WorkbenchComponent[] wbModules) {
        ArrayList<WorkbenchComponent> unsortedList = new ArrayList<WorkbenchComponent>(wbModules.length - 1);
        int i = 1;
        while (i < wbModules.length) {
            unsortedList.add(wbModules[i]);
            ++i;
        }
        WorkbenchComponent firstModule = wbModules[0];
        if (firstModule == null) {
            return null;
        }
        List sortedList = new ArrayList(wbModules.length);
        try {
            sortedList = this.computeModuleBuildOrder(firstModule, sortedList, unsortedList, new Stack());
        }
        catch (UnresolveableURIException e) {
            e.printStackTrace();
        }
        return sortedList;
    }

    private List populateFullModuleBuilderDataModelList() {
        StructureEdit moduleCore = (StructureEdit)this.model.getProperty("IProjectComponentsBuilderDataModelProperties.COMPONENT_CORE");
        ArrayList<IDataModel> moduleBuilderDataModelList = new ArrayList<IDataModel>();
        WorkbenchComponent[] wbModules = moduleCore.getWorkbenchModules();
        if (wbModules == null || wbModules.length == 0) {
            return null;
        }
        List sortedList = this.computeModuleBuildOrder(wbModules);
        if (sortedList == null) {
            return moduleBuilderDataModelList;
        }
        IDataModel dataModel = null;
        IProject curProject = (IProject)this.model.getProperty("IProjectComponentsBuilderDataModelProperties.PROJECT");
        String builderType = null;
        int i = 0;
        while (i < sortedList.size()) {
            String typeId;
            WorkbenchComponent wbComponent = (WorkbenchComponent)sortedList.get(i);
            ComponentType type = wbComponent.getComponentType();
            if (type != null && (typeId = type.getComponentTypeId()) != null && (dataModel = DataModelEnablementFactory.createDataModel((String)(builderType = String.valueOf(typeId) + ".builder"), (IProject)curProject)) != null) {
                IVirtualComponent vComponent = ComponentCore.createComponent(curProject, wbComponent.getName());
                dataModel.setProperty("IWorkbenchComponentBuilderDataModelProperties.BUILD_KIND_FOR_DEP", this.model.getProperty("IProjectComponentsBuilderDataModelProperties.BUILD_KIND"));
                dataModel.setProperty("IWorkbenchComponentBuilderDataModelProperties.VIRTUAL_COMPONENT", (Object)vComponent);
                moduleBuilderDataModelList.add(dataModel);
            }
            ++i;
        }
        return moduleBuilderDataModelList;
    }

    private List populateDeltaModuleBuilderDataModelList(ResourceDelta delta) {
        return this.populateFullModuleBuilderDataModelList();
    }

    public IDataModelOperation getDefaultOperation() {
        return new ProjectComponentsBuilderOperation(this.model);
    }
}

