/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.validation;

import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xsd.ui.internal.validation.ValidateAction;

public class Validator
implements IValidator {
    private final String GET_FILE = "getFile";
    public final String GET_PROJECT_FILES = "getAllFiles";

    public void validate(IFile file) {
        ValidateAction validateAction = new ValidateAction(file, false);
        validateAction.setValidator(this);
        validateAction.run();
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        String[] changedFiles = helper.getURIs();
        if (changedFiles != null && changedFiles.length > 0) {
            int i = 0;
            while (i < changedFiles.length) {
                Object[] parms;
                IFile file;
                String fileName = changedFiles[i];
                if (fileName != null && (file = (IFile)helper.loadModel("getFile", parms = new Object[]{fileName})) != null && this.shouldValidate(file)) {
                    if (helper.loadModel("inputStream") instanceof InputStream) {
                        this.validate(file, (InputStream)helper.loadModel("inputStream"), reporter);
                    } else {
                        this.validateIfNeeded(file, helper, reporter);
                    }
                }
                ++i;
            }
        } else {
            Object[] parms = new Object[]{this.getClass().getName()};
            Collection files = (Collection)helper.loadModel("getAllFiles", parms);
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                IFile file = (IFile)iter.next();
                if (!this.shouldValidate(file)) continue;
                this.validateIfNeeded(file, helper, reporter);
            }
        }
    }

    private void validate(IFile file, InputStream inputStream, IReporter reporter) {
        ValidateAction validateAction = new ValidateAction(file, false);
        validateAction.setValidator(this);
        if (inputStream != null) {
            validateAction.setInputStream(inputStream);
            validateAction.setReporter(reporter);
        }
        validateAction.run();
    }

    protected void validateIfNeeded(IFile file, IValidationContext helper, IReporter reporter) {
        ValidatorManager.getManager();
        Integer ruleGroupInt = (Integer)helper.loadModel("PASS_LEVEL", null);
        int n = ruleGroupInt == null ? 3 : ruleGroupInt;
        Object stream = helper.loadModel("inputStream");
        if (stream instanceof InputStream) {
            this.validate(file, (InputStream)stream, reporter);
        } else {
            this.validate(file, null, reporter);
        }
    }

    public void cleanup(IReporter reporter) {
    }

    boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0 && (resource.getType() & 8) == 0);
        return true;
    }
}

