/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.util.Assert;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.INameUpdating;
import org.eclipse.wst.xsd.ui.internal.refactor.structure.MakeTypeGlobalChange;
import org.eclipse.xsd.XSDTypeDefinition;

public class MakeTypeGlobalProcessor
extends RenameProcessor
implements INameUpdating {
    private XSDTypeDefinition fTypeComponent;
    private String fNewElementName;
    public static final String IDENTIFIER = "org.eclipse.wst.ui.xsd.makeTypeGlobalProcessor";

    public MakeTypeGlobalProcessor(XSDTypeDefinition element, String newName) {
        this.fTypeComponent = element;
        this.fNewElementName = newName;
    }

    public XSDTypeDefinition getTypeComponent() {
        return this.fTypeComponent;
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return new String[0];
    }

    protected void loadDerivedParticipants(RefactoringStatus status, List result, String[] natures, SharableParticipants shared) throws CoreException {
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        MakeTypeGlobalChange makeTypeGlobalChange;
        pm.beginTask("", 1);
        try {
            makeTypeGlobalChange = new MakeTypeGlobalChange(this.fTypeComponent, this.getNewElementName());
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return makeTypeGlobalChange;
    }

    public Object[] getElements() {
        return new Object[]{this.fTypeComponent};
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return RefactoringMessages.getFormattedString("MakeLocalTypeGlobalRefactoring.name", new String[]{this.getNewElementName()});
    }

    public boolean isApplicable() throws CoreException {
        return this.fTypeComponent != null;
    }

    public RefactoringStatus checkNewElementName(String newName) {
        Assert.isNotNull((Object)newName, (String)"new name");
        return new RefactoringStatus();
    }

    public Object getNewElement() throws CoreException {
        return null;
    }

    public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        RenameArguments arguments = new RenameArguments(this.getNewElementName(), true);
        String[] natures = this.getAffectedProjectNatures();
        ArrayList result = new ArrayList();
        this.loadElementParticipants(status, result, arguments, natures, sharedParticipants);
        this.loadDerivedParticipants(status, result, natures, sharedParticipants);
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    protected void loadElementParticipants(RefactoringStatus status, List result, RenameArguments arguments, String[] natures, SharableParticipants shared) throws CoreException {
        Object[] elements = this.getElements();
        int i = 0;
        while (i < elements.length) {
            result.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)elements[i], (RenameArguments)arguments, (String[])natures, (SharableParticipants)shared)));
            ++i;
        }
    }

    public void setNewElementName(String newName) {
        this.fNewElementName = newName;
    }

    public String getNewElementName() {
        return this.fNewElementName;
    }

    public String getCurrentElementName() {
        return this.fNewElementName;
    }
}

