/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.xsd.XSDSchema;

public abstract class SelectionDispatchAction
extends Action
implements ISelectionChangedListener {
    private ISelectionProvider fSelectionProvider;
    private XSDSchema fSchema;

    protected SelectionDispatchAction(ISelectionProvider selectionProvider) {
        Assert.isNotNull((Object)selectionProvider);
        this.fSelectionProvider = selectionProvider;
    }

    public ISelection getSelection() {
        if (this.getSelectionProvider() != null) {
            return this.getSelectionProvider().getSelection();
        }
        return null;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSelectionProvider;
    }

    public void update(ISelection selection) {
        this.dispatchSelectionChanged(selection);
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object object = selection.getFirstElement();
            this.setEnabled(this.canEnable(object));
        } else {
            this.setEnabled(false);
        }
    }

    protected boolean canEnable(Object selectedObject) {
        return false;
    }

    public void run(IStructuredSelection selection) {
        this.run((ISelection)selection);
    }

    public void selectionChanged(ITextSelection selection) {
        this.selectionChanged((ISelection)selection);
    }

    public void run(ITextSelection selection) {
        this.run((ISelection)selection);
    }

    public void selectionChanged(ISelection selection) {
        this.setEnabled(false);
    }

    public void run(ISelection selection) {
        System.out.println("SelectionDispatchAction.run");
    }

    public void run() {
        this.dispatchRun(this.getSelection());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.dispatchSelectionChanged(event.getSelection());
    }

    private void dispatchSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
        } else if (selection instanceof ITextSelection) {
            this.selectionChanged((ITextSelection)selection);
        } else {
            this.selectionChanged(selection);
        }
    }

    protected void dispatchRun(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.run((IStructuredSelection)selection);
        } else if (selection instanceof ITextSelection) {
            this.run((ITextSelection)selection);
        } else {
            this.run(selection);
        }
    }

    public XSDSchema getSchema() {
        return this.fSchema;
    }

    public void setSchema(XSDSchema schema) {
        this.fSchema = schema;
    }
}

