/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.xsd.ui.internal.properties.section.XSDWorkbookPage;

public class XSDWorkbook {
    private CTabFolder tabFolder;
    private CTabItem selectedTab;

    public XSDWorkbook(Composite parent, int style) {
        this.tabFolder = new CTabFolder(parent, style);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                XSDWorkbookPage selectedPage;
                CTabItem newSelectedTab = (CTabItem)event.item;
                if (XSDWorkbook.this.selectedTab == newSelectedTab) {
                    return;
                }
                if (XSDWorkbook.this.selectedTab != null && !XSDWorkbook.this.selectedTab.isDisposed() && !(selectedPage = XSDWorkbook.this.getWorkbookPage(XSDWorkbook.this.selectedTab)).deactivate()) {
                    XSDWorkbook.this.tabFolder.setSelection(XSDWorkbook.this.selectedTab);
                    return;
                }
                XSDWorkbook.this.selectedTab = newSelectedTab;
                XSDWorkbookPage newSelectedPage = XSDWorkbook.this.getWorkbookPage(newSelectedTab);
                if (newSelectedPage != null) {
                    newSelectedPage.activate();
                }
            }
        });
    }

    public XSDWorkbookPage getSelectedPage() {
        int index = this.tabFolder.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        CTabItem selectedItem = this.tabFolder.getItem(index);
        return (XSDWorkbookPage)selectedItem.getData();
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    protected XSDWorkbookPage getWorkbookPage(CTabItem item) {
        try {
            return (XSDWorkbookPage)item.getData();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public XSDWorkbookPage[] getWorkbookPages() {
        CTabItem[] tabItems = this.tabFolder.getItems();
        int nItems = tabItems.length;
        XSDWorkbookPage[] workbookPages = new XSDWorkbookPage[nItems];
        int i = 0;
        while (i < nItems) {
            workbookPages[i] = this.getWorkbookPage(tabItems[i]);
            ++i;
        }
        return workbookPages;
    }

    public void setSelectedPage(XSDWorkbookPage workbookPage) {
        CTabItem newSelectedTab = workbookPage.getTabItem();
        if (this.selectedTab == newSelectedTab) {
            return;
        }
        this.selectedTab = newSelectedTab;
        workbookPage.activate();
        this.tabFolder.setSelection(newSelectedTab);
    }
}

