/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.ViewUtility;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.wst.xsd.ui.internal.widgets.TypeSection;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypesDialog
extends Dialog
implements SelectionListener,
Listener {
    XSDSchema xsdSchema;
    String property;
    String type;
    Object typeObject;
    Text textField;
    Table table;
    TableColumn tableColumn;
    Element element;
    boolean showComplexTypes = true;
    TypeSection typeSection;
    boolean showAnonymous = true;
    String previousStringType = "";
    boolean isAnonymous;
    int previousType;

    public TypesDialog(Shell parentShell, Element element, Object id, XSDSchema xsdSchema) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.element = element;
        this.property = (String)id;
        this.element = element;
        this.xsdSchema = xsdSchema;
        if (XSDDOMHelper.inputEquals(element, "element", false)) {
            this.showComplexTypes = true;
        } else if (XSDDOMHelper.inputEquals(element, "attribute", false) || XSDDOMHelper.inputEquals(element, "list", false) || XSDDOMHelper.inputEquals(element, "union", false)) {
            this.showComplexTypes = false;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.type = this.table.getItem(this.table.getSelectionIndex()).getText();
            this.ok();
        }
        super.buttonPressed(buttonId);
    }

    public Object getTypeObject() {
        return this.typeObject;
    }

    public String getType() {
        return this.type;
    }

    public Control createDialogArea(Composite parent) {
        Composite client = (Composite)super.createDialogArea(parent);
        this.getShell().setText(XSDEditorPlugin.getXSDString("_UI_LABEL_AVAILABLE_TYPES"));
        this.typeObject = null;
        GridLayout gl = new GridLayout(1, true);
        client.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.horizontalIndent = 0;
        client.setLayoutData((Object)gd);
        this.typeSection = new TypeSection(client);
        this.typeSection.setShowUserComplexType(this.showComplexTypes);
        this.typeSection.createClient(client);
        this.typeSection.getSimpleType().setSelection(false);
        this.typeSection.getSimpleType().addSelectionListener((SelectionListener)this);
        this.typeSection.getUserSimpleType().addSelectionListener((SelectionListener)this);
        if (this.showComplexTypes) {
            this.typeSection.getUserComplexType().addSelectionListener((SelectionListener)this);
        }
        this.textField = ViewUtility.createTextField(client, 50);
        this.textField.addListener(24, (Listener)this);
        ViewUtility.createVerticalFiller(client, 0);
        this.table = new Table(client, 66308);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(true);
        this.table.addSelectionListener((SelectionListener)this);
        GridData gd2 = new GridData();
        gd2.grabExcessHorizontalSpace = true;
        gd2.grabExcessVerticalSpace = true;
        gd2.horizontalAlignment = 4;
        gd2.verticalAlignment = 4;
        gd2.heightHint = 200;
        this.table.setLayoutData((Object)gd2);
        this.table.addListener(11, (Listener)this);
        this.tableColumn = new TableColumn(this.table, 16384);
        this.tableColumn.setResizable(true);
        this.tableColumn.setWidth(200);
        this.handleSetInput();
        return client;
    }

    public void handleEvent(Event event) {
        if (event.type == 11 && event.widget == this.table) {
            this.tableColumn.setWidth(this.table.getSize().x);
        } else if (event.type == 24 && event.widget == this.textField) {
            boolean showAll = false;
            String inputString = this.textField.getText();
            if (inputString.equals("")) {
                showAll = true;
            } else {
                inputString = this.insertString("*", ".", inputString);
                inputString = this.insertString("?", ".", inputString);
                inputString = String.valueOf(inputString) + ".*";
            }
            try {
                if (this.typeSection.getSimpleType().getSelection()) {
                    if (showAll) {
                        this.populateBuiltInType();
                    } else {
                        this.populateBuiltInType(inputString);
                    }
                } else if (this.typeSection.getUserComplexType().getSelection()) {
                    if (showAll) {
                        this.populateUserComplexType();
                    } else {
                        this.populateUserComplexType(inputString);
                    }
                } else if (this.typeSection.getUserSimpleType().getSelection()) {
                    if (showAll) {
                        this.populateUserSimpleType();
                    } else {
                        this.populateUserSimpleType(inputString);
                    }
                }
            }
            catch (Exception exception) {}
        }
        this.setEnabledState();
    }

    private void setEnabledState() {
        if (this.table.getSelectionIndex() != -1) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    private String insertString(String target, String newString, String string) {
        new ArrayList();
        StringBuffer stringBuffer = new StringBuffer(string);
        int index = stringBuffer.indexOf(target);
        while (index != -1) {
            stringBuffer = stringBuffer.insert(index, newString);
            index = stringBuffer.indexOf(target, index + newString.length() + target.length());
        }
        return stringBuffer.toString();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.typeSection.getSimpleType() && this.typeSection.getSimpleType().getSelection()) {
            if (this.textField.getText().equals("")) {
                this.populateBuiltInType();
            } else {
                this.populateBuiltInType(this.textField.getText());
            }
        } else if (e.widget == this.typeSection.getUserComplexType() && this.typeSection.getUserComplexType().getSelection()) {
            if (this.textField.getText().equals("")) {
                this.populateUserComplexType();
            } else {
                this.populateUserComplexType(this.textField.getText());
            }
        } else if (e.widget == this.typeSection.getUserSimpleType() && this.typeSection.getUserSimpleType().getSelection()) {
            if (this.textField.getText().equals("")) {
                this.populateUserSimpleType();
            } else {
                this.populateUserSimpleType(this.textField.getText());
            }
        }
        this.setEnabledState();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void ok() {
        TableItem[] items = this.table.getItems();
        int selection = this.table.getSelectionIndex();
        if (items != null && items.length > 0 && selection >= 0) {
            this.typeObject = items[selection].getData();
        }
        if (!XSDDOMHelper.inputEquals(this.element, "union", false)) {
            if (this.typeObject.equals("**anonymous**")) {
                if (this.typeSection.getUserSimpleType().getSelection()) {
                    this.updateElementToAnonymous(this.element, "simpleType");
                } else {
                    this.updateElementToAnonymous(this.element, "complexType");
                }
                this.element.removeAttribute(this.property);
            } else {
                XSDDOMHelper.updateElementToNotAnonymous(this.element);
                this.element.setAttribute(this.property, this.typeObject.toString());
            }
        }
    }

    public void handleSetInput() {
        this.table.removeAll();
        this.isAnonymous = this.checkForAnonymousType(this.element);
        Attr attr = this.element.getAttributeNode(this.property);
        if (attr != null) {
            String value = attr.getValue();
            if (this.typeSection.getBuiltInTypeNamesList(this.xsdSchema).contains(value)) {
                this.typeSection.getSimpleType().setSelection(true);
                this.populateBuiltInType();
                int i = this.typeSection.getBuiltInTypeNamesList(this.xsdSchema).indexOf(value);
                this.table.setSelection(i);
                this.previousType = 1;
            } else if (this.typeSection.getUserSimpleTypeNamesList(this.xsdSchema).contains(value)) {
                this.typeSection.getUserSimpleType().setSelection(true);
                this.populateUserSimpleType();
                int i = this.typeSection.getUserSimpleTypeNamesList(this.xsdSchema).indexOf(value);
                if (this.showAnonymous) {
                    this.table.setSelection(i + 1);
                } else {
                    this.table.setSelection(i);
                }
                this.previousType = 2;
            } else if (this.typeSection.getUserComplexTypeNamesList(this.xsdSchema).contains(value)) {
                this.typeSection.getUserComplexType().setSelection(true);
                this.populateUserComplexType();
                int i = this.typeSection.getUserComplexTypeNamesList(this.xsdSchema).indexOf(value);
                if (this.showAnonymous) {
                    this.table.setSelection(i + 1);
                } else {
                    this.table.setSelection(i);
                }
                this.previousType = 3;
            } else {
                this.typeSection.getUserSimpleType().setSelection(true);
                this.populateUserSimpleType();
                this.previousType = 2;
            }
        } else if (this.isAnonymous) {
            if (this.isSTAnonymous(this.element)) {
                this.typeSection.getUserSimpleType().setSelection(true);
                this.populateUserSimpleType();
                this.previousType = 2;
            } else {
                this.typeSection.getUserComplexType().setSelection(true);
                this.populateUserComplexType();
                this.previousType = 3;
            }
            this.table.setSelection(0);
        } else {
            this.typeSection.getSimpleType().setSelection(true);
            this.populateBuiltInType();
            this.table.setSelection(0);
            this.previousType = 1;
        }
        if (this.table.getSelection() != null && this.table.getSelection().length > 0) {
            this.previousStringType = this.table.getSelection()[0].getText();
        }
    }

    public void populateBuiltInType() {
        this.table.removeAll();
        List items = this.getBuiltInTypeNamesList();
        int i = 0;
        while (i < items.size()) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(items.get(i).toString());
            item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif"));
            item.setData(items.get(i));
            ++i;
        }
    }

    public void populateBuiltInType(String fragment) {
        this.table.removeAll();
        List items = this.getBuiltInTypeNamesList();
        fragment = fragment.toLowerCase();
        Pattern regex = Pattern.compile(fragment);
        int i = 0;
        while (i < items.size()) {
            String itemString = items.get(i).toString().toLowerCase();
            Matcher m = regex.matcher(itemString);
            if (itemString.startsWith(fragment) || m.matches()) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(items.get(i).toString());
                item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif"));
                item.setData(items.get(i));
            }
            ++i;
        }
        this.table.select(0);
    }

    public void populateUserComplexType() {
        this.table.removeAll();
        if (this.showAnonymous) {
            TableItem anonymousItem = new TableItem(this.table, 0);
            anonymousItem.setText("**anonymous**");
            anonymousItem.setData((Object)"**anonymous**");
        }
        List items = this.getUserComplexTypeNamesList();
        int i = 0;
        while (i < items.size()) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(items.get(i).toString());
            item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDComplexType.gif"));
            item.setData(items.get(i));
            ++i;
        }
    }

    public void populateUserComplexType(String fragment) {
        this.table.removeAll();
        fragment = fragment.toLowerCase();
        Pattern regex = Pattern.compile(fragment);
        if (this.showAnonymous) {
            Matcher m = regex.matcher("**anonymous**");
            if ("**anonymous**".startsWith(fragment) || m.matches()) {
                TableItem anonymousItem = new TableItem(this.table, 0);
                anonymousItem.setText("**anonymous**");
                anonymousItem.setData((Object)"**anonymous**");
            }
        }
        List items = this.getUserComplexTypeNamesList();
        int i = 0;
        while (i < items.size()) {
            String itemString = items.get(i).toString().toLowerCase();
            Matcher m = regex.matcher(itemString);
            if (itemString.startsWith(fragment) || m.matches()) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(items.get(i).toString());
                item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDComplexType.gif"));
                item.setData(items.get(i));
            }
            ++i;
        }
        this.table.select(0);
    }

    public void populateUserSimpleType() {
        this.table.removeAll();
        if (this.showAnonymous) {
            TableItem anonymousItem = new TableItem(this.table, 0);
            anonymousItem.setText("**anonymous**");
            anonymousItem.setData((Object)"**anonymous**");
        }
        List items = this.getUserSimpleTypeNamesList();
        int i = 0;
        while (i < items.size()) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(items.get(i).toString());
            item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif"));
            item.setData(items.get(i));
            ++i;
        }
    }

    public void populateUserSimpleType(String fragment) {
        this.table.removeAll();
        fragment = fragment.toLowerCase();
        Pattern regex = Pattern.compile(fragment);
        if (this.showAnonymous) {
            Matcher m = regex.matcher("**anonymous**");
            if ("**anonymous**".startsWith(fragment) || m.matches()) {
                TableItem anonymousItem = new TableItem(this.table, 0);
                anonymousItem.setText("**anonymous**");
                anonymousItem.setData((Object)"**anonymous**");
            }
        }
        List items = this.getUserSimpleTypeNamesList();
        int i = 0;
        while (i < items.size()) {
            String itemString = items.get(i).toString().toLowerCase();
            Matcher m = regex.matcher(itemString);
            if (itemString.startsWith(fragment) || m.matches()) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(items.get(i).toString());
                item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif"));
                item.setData(items.get(i));
            }
            ++i;
        }
        this.table.select(0);
    }

    boolean checkForAnonymousType(Element element) {
        XSDDOMHelper helper = new XSDDOMHelper();
        boolean isAnonymous = false;
        Node aNode = helper.getChildNode(element, "simpleType");
        if (aNode != null) {
            return true;
        }
        aNode = helper.getChildNode(element, "complexType");
        if (aNode != null) {
            isAnonymous = true;
        }
        return isAnonymous;
    }

    void updateElementToAnonymous(Element element, String xsdType) {
        String prefix = element.getPrefix();
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        XSDDOMHelper.updateElementToNotAnonymous(element);
        this.hasElementChildren(element);
        Element childNode = null;
        if (xsdType.equals("complexType")) {
            childNode = element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + "complexType");
        } else if (xsdType.equals("simpleType")) {
            childNode = element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + "simpleType");
            Element restrictionNode = element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + "restriction");
            restrictionNode.setAttribute("base", String.valueOf(prefix) + "string");
            childNode.appendChild(restrictionNode);
        }
        if (childNode != null) {
            XSDDOMHelper helper = new XSDDOMHelper();
            Node annotationNode = helper.getChildNode(element, "annotation");
            if (annotationNode == null) {
                Node firstChild = element.getFirstChild();
                element.insertBefore(childNode, firstChild);
            } else {
                Node nextSibling = annotationNode.getNextSibling();
                element.insertBefore(childNode, nextSibling);
            }
            XSDDOMHelper.formatChild(childNode);
        }
    }

    boolean isSTAnonymous(Element element) {
        XSDDOMHelper helper = new XSDDOMHelper();
        Node aNode = helper.getChildNode(element, "simpleType");
        return aNode != null && XSDDOMHelper.inputEquals(aNode, "simpleType", false);
    }

    boolean isCTAnonymous(Element element) {
        XSDDOMHelper helper = new XSDDOMHelper();
        Node aNode = helper.getChildNode(element, "complexType");
        return aNode != null && XSDDOMHelper.inputEquals(aNode, "complexType", false);
    }

    XSDTypeDefinition getAnonymousTypeDefinition(Element element) {
        XSDConcreteComponent component;
        XSDDOMHelper helper = new XSDDOMHelper();
        Node typeDefinitionNode = helper.getChildNode(element, "simpleType");
        if (typeDefinitionNode == null) {
            typeDefinitionNode = helper.getChildNode(element, "complexType");
        }
        if (typeDefinitionNode != null && (component = this.xsdSchema.getCorrespondingComponent(typeDefinitionNode)) instanceof XSDTypeDefinition) {
            return (XSDTypeDefinition)component;
        }
        return null;
    }

    public List getBuiltInTypeNamesList() {
        TypesHelper helper = new TypesHelper(this.xsdSchema);
        return helper.getBuiltInTypeNamesList();
    }

    public List getUserSimpleTypeNamesList() {
        TypesHelper helper = new TypesHelper(this.xsdSchema);
        return helper.getUserSimpleTypeNamesList();
    }

    public List getUserComplexTypeNamesList() {
        TypesHelper helper = new TypesHelper(this.xsdSchema);
        return helper.getUserComplexTypeNamesList();
    }

    protected boolean hasElementChildren(Node parentNode) {
        boolean hasChildrenElements = false;
        if (parentNode != null && parentNode.hasChildNodes()) {
            NodeList nodes = parentNode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                if (nodes.item(i) instanceof Element) {
                    hasChildrenElements = true;
                    break;
                }
                ++i;
            }
        }
        return hasChildrenElements;
    }
}

