/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.xsd.ui.internal.properties.section.TypesDialog;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleContentBaseTypeOptionsDialog
extends TypesDialog {
    public SimpleContentBaseTypeOptionsDialog(Shell parentShell, Element element, Object id, XSDSchema xsdSchema) {
        super(parentShell, element, id, xsdSchema);
        this.showAnonymous = false;
    }

    protected void ok() {
        TableItem[] items = this.table.getItems();
        int selection = this.table.getSelectionIndex();
        if (items != null && items.length > 0 && selection >= 0) {
            this.typeObject = items[selection].getData();
        }
    }

    public void handleSetInput() {
        XSDDOMHelper domHelper = new XSDDOMHelper();
        this.typeSection.getSimpleType().setSelection(false);
        this.typeSection.getUserSimpleType().setSelection(false);
        this.typeSection.getUserComplexType().setSelection(false);
        this.showAnonymous = false;
        if (this.element != null) {
            String derivedBy = domHelper.getDerivedByName(this.element);
            String baseType = domHelper.getBaseType(this.element);
            boolean derivedByRestriction = true;
            if (XSDDOMHelper.inputEquals(this.element, "complexContent", false)) {
                this.typeSection.getSimpleType().setEnabled(false);
                this.typeSection.getUserSimpleType().setEnabled(false);
                this.typeSection.getUserComplexType().setSelection(true);
                this.previousType = 3;
            } else if (XSDDOMHelper.inputEquals(this.element, "simpleContent", false)) {
                this.typeSection.getSimpleType().setEnabled(false);
                this.typeSection.getUserSimpleType().setEnabled(false);
                if (derivedBy.equals("restriction")) {
                    this.typeSection.getSimpleType().setEnabled(false);
                    this.typeSection.getUserSimpleType().setEnabled(false);
                    this.typeSection.getUserComplexType().setEnabled(true);
                } else if (derivedBy.equals("extension")) {
                    derivedByRestriction = false;
                    this.typeSection.getSimpleType().setEnabled(true);
                    this.typeSection.getUserSimpleType().setEnabled(true);
                    this.typeSection.getUserComplexType().setEnabled(true);
                }
            }
            if (derivedBy != null) {
                if (baseType != null && !baseType.equals("")) {
                    Element parent = (Element)this.element.getParentNode();
                    XSDConcreteComponent component = null;
                    if (parent != null) {
                        component = this.xsdSchema.getCorrespondingComponent((Node)parent);
                    }
                    XSDTypeDefinition baseTypeDefinition = null;
                    if (component instanceof XSDComplexTypeDefinition) {
                        XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)component;
                        baseTypeDefinition = complexType.getBaseTypeDefinition();
                    }
                    if (this.typeSection.getBuiltInTypeNamesList(this.xsdSchema).contains(baseType) && !derivedByRestriction) {
                        this.typeSection.getSimpleType().setSelection(true);
                        this.populateBuiltInType();
                        int i = this.typeSection.getBuiltInTypeNamesList(this.xsdSchema).indexOf(baseType);
                        this.table.setSelection(i);
                        this.previousType = 1;
                    } else if (baseTypeDefinition instanceof XSDSimpleTypeDefinition && !derivedByRestriction) {
                        this.typeSection.getUserSimpleType().setSelection(true);
                        this.populateUserSimpleType();
                        int i = this.typeSection.getUserSimpleTypeNamesList(this.xsdSchema).indexOf(baseType);
                        if (this.showAnonymous) {
                            this.table.setSelection(i + 1);
                        } else {
                            this.table.setSelection(i);
                        }
                        this.previousType = 2;
                    } else if (baseTypeDefinition instanceof XSDComplexTypeDefinition) {
                        this.typeSection.getUserComplexType().setSelection(true);
                        this.populateUserComplexType();
                        int i = this.typeSection.getUserComplexTypeNamesList(this.xsdSchema).indexOf(baseType);
                        if (this.showAnonymous) {
                            this.table.setSelection(i + 1);
                        } else {
                            this.table.setSelection(i);
                        }
                        this.previousType = 3;
                    }
                } else {
                    this.typeSection.getUserComplexType().setSelection(true);
                    this.populateUserComplexType();
                    this.table.setSelection(0);
                }
            }
        }
    }
}

