/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.section.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.wizards.RegexWizard;
import org.eclipse.xsd.XSDPatternFacet;
import org.w3c.dom.Element;

public class PatternSection
extends AbstractSection {
    Text patternText;
    Button button;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.patternText = this.getWidgetFactory().createText(composite, "");
        CLabel nameLabel = this.getWidgetFactory().createCLabel(composite, String.valueOf(XSDEditorPlugin.getXSDString("_UI_VALUE")) + ":");
        this.button = this.getWidgetFactory().createButton(composite, "", 8);
        this.button.setImage(XSDEditorPlugin.getXSDImage("icons/browsebutton.gif"));
        this.patternText.addListener(24, (Listener)this);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.patternText, -5);
        data.top = new FormAttachment((Control)this.button, 0, 0x1000000);
        nameLabel.setLayoutData((Object)data);
        this.button.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(100, -this.rightMarginSpace + 2);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.patternText, 0, 0x1000000);
        this.button.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment((Control)this.button, 0);
        this.patternText.setLayoutData((Object)data);
    }

    public void refresh() {
        this.setListenerEnabled(false);
        Object input = this.getInput();
        this.patternText.setText("");
        if (input != null) {
            String result;
            Element element = null;
            if (input instanceof XSDPatternFacet) {
                element = ((XSDPatternFacet)input).getElement();
            }
            if (element != null && (result = element.getAttribute("value")) != null) {
                this.patternText.setText(result);
            }
        }
        this.setListenerEnabled(true);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.button) {
            Shell shell = Display.getCurrent().getActiveShell();
            Element element = ((XSDPatternFacet)this.getInput()).getElement();
            String initialValue = element.getAttribute("value");
            if (initialValue == null) {
                initialValue = "";
            }
            RegexWizard wizard = new RegexWizard(initialValue);
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
            wizardDialog.setBlockOnOpen(true);
            wizardDialog.create();
            int result = wizardDialog.open();
            if (result == 0) {
                String newPattern = wizard.getPattern();
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_PATTERN_VALUE_CHANGE"), element);
                element.setAttribute("value", newPattern);
                ((XSDPatternFacet)this.getInput()).setLexicalValue(newPattern);
                this.endRecording(element);
            }
            this.refresh();
        }
    }

    public void doHandleEvent(Event event) {
        if (event.widget == this.patternText) {
            XSDPatternFacet pattern = (XSDPatternFacet)this.getInput();
            String newValue = this.patternText.getText();
            if (newValue.length() > 0) {
                pattern.setLexicalValue(newValue);
            }
        }
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }
}

