/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.common.ui.internal.viewers.ResourceFilter;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.section.CommonDirectivesSection;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.XSDExternalFileCleanup;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDSchemaHelper;
import org.eclipse.wst.xsd.ui.internal.wizards.XSDSelectIncludeFileWizard;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.w3c.dom.Element;

public class NamespaceAndSchemaLocationSection
extends CommonDirectivesSection {
    Text namespaceText;
    Text prefixText;
    protected String oldPrefixValue;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        CLabel namespaceLabel = this.getWidgetFactory().createCLabel(composite, XSDEditorPlugin.getXSDString("_UI_LABEL_NAMESPACE"));
        this.namespaceText = this.getWidgetFactory().createText(composite, "", 0);
        this.namespaceText.setEditable(false);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.namespaceText, 5);
        data.top = new FormAttachment((Control)this.namespaceText, 0, 0x1000000);
        namespaceLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 110);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment(0, 0);
        this.namespaceText.setLayoutData((Object)data);
        CLabel prefixLabel = this.getWidgetFactory().createCLabel(composite, XSDEditorPlugin.getXSDString("_UI_LABEL_PREFIX"));
        this.prefixText = this.getWidgetFactory().createText(composite, "", 0);
        this.prefixText.setEditable(true);
        this.prefixText.addListener(24, (Listener)this);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.prefixText, 0);
        data.top = new FormAttachment((Control)this.prefixText, 0, 0x1000000);
        prefixLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 110);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment((Control)this.namespaceText, 4);
        this.prefixText.setLayoutData((Object)data);
        CLabel schemaLocationLabel = this.getWidgetFactory().createCLabel(composite, XSDEditorPlugin.getXSDString("_UI_LABEL_SCHEMA_LOCATION"));
        this.schemaLocationText = this.getWidgetFactory().createText(composite, "", 0);
        this.wizardButton = this.getWidgetFactory().createButton(composite, "", 0);
        this.wizardButton.setImage(XSDEditorPlugin.getXSDImage("icons/browsebutton.gif"));
        FormData buttonFormData = new FormData();
        buttonFormData.left = new FormAttachment(100, -this.rightMarginSpace + 2);
        buttonFormData.right = new FormAttachment(100, 0);
        buttonFormData.top = new FormAttachment((Control)this.schemaLocationText, 0, 0x1000000);
        this.wizardButton.setLayoutData((Object)buttonFormData);
        this.wizardButton.addSelectionListener((SelectionListener)this);
        this.schemaLocationText.setEditable(true);
        FormData schemaLocationData = new FormData();
        schemaLocationData.left = new FormAttachment(0, 110);
        schemaLocationData.right = new FormAttachment((Control)this.wizardButton, 0);
        schemaLocationData.top = new FormAttachment((Control)this.prefixText, 4);
        this.schemaLocationText.setLayoutData((Object)schemaLocationData);
        this.schemaLocationText.addListener(24, (Listener)this);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.schemaLocationText, 0);
        data.top = new FormAttachment((Control)this.schemaLocationText, 0, 0x1000000);
        schemaLocationLabel.setLayoutData((Object)data);
        this.errorText = new StyledText(composite, 0x800000);
        this.errorText.setEditable(false);
        this.errorText.setEnabled(false);
        this.errorText.setText("");
        data = new FormData();
        data.left = new FormAttachment((Control)this.schemaLocationText, 0, 16384);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.schemaLocationText, 0);
        this.errorText.setLayoutData((Object)data);
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.wizardButton) {
            this.setListenerEnabled(false);
            Shell shell = Display.getCurrent().getActiveShell();
            IFile currentIFile = ((IFileEditorInput)this.getActiveEditor().getEditorInput()).getFile();
            ResourceFilter filter = new ResourceFilter(new String[]{".xsd"}, new IFile[]{currentIFile}, null);
            XSDSelectIncludeFileWizard fileSelectWizard = new XSDSelectIncludeFileWizard(this.xsdSchema, false, XSDEditorPlugin.getXSDString("_UI_FILEDIALOG_SELECT_XML_SCHEMA"), XSDEditorPlugin.getXSDString("_UI_FILEDIALOG_SELECT_XML_DESC"), (ViewerFilter)filter, (IStructuredSelection)this.selection);
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)fileSelectWizard);
            wizardDialog.create();
            wizardDialog.setBlockOnOpen(true);
            int result = wizardDialog.open();
            String value = this.schemaLocationText.getText();
            this.prefixText.removeListener(24, (Listener)this);
            if (result == 0) {
                this.errorText.setText("");
                IFile selectedIFile = fileSelectWizard.getResultFile();
                String schemaFileString = value;
                schemaFileString = selectedIFile != null ? URIHelper.getRelativeURI((IPath)selectedIFile.getLocation(), (IPath)currentIFile.getLocation()) : fileSelectWizard.getURL();
                String namespace = fileSelectWizard.getNamespace();
                if (namespace == null) {
                    namespace = "";
                }
                XSDSchema externalSchema = fileSelectWizard.getExternalSchema();
                this.handleSchemaLocationChange(schemaFileString, namespace, externalSchema);
            }
            this.setListenerEnabled(true);
            this.prefixText.addListener(24, (Listener)this);
        }
    }

    protected void handleSchemaLocationChange(String schemaFileString, String namespace, XSDSchema externalSchema) {
        XSDConcreteComponent comp = (XSDConcreteComponent)this.getInput();
        if (comp instanceof XSDImport) {
            XSDImport xsdImport = (XSDImport)comp;
            Element importElement = comp.getElement();
            this.beginRecording(XSDEditorPlugin.getXSDString("_UI_IMPORT_CHANGE"), importElement);
            xsdImport.setNamespace(namespace);
            xsdImport.setSchemaLocation(schemaFileString);
            xsdImport.setResolvedSchema(externalSchema);
            Map map = this.xsdSchema.getQNamePrefixToNamespaceMap();
            XSDSchema referencedSchema = xsdImport.getResolvedSchema();
            if (referencedSchema != null) {
                XSDExternalFileCleanup cleanHelper = new XSDExternalFileCleanup(referencedSchema);
                cleanHelper.visitSchema(this.xsdSchema);
            }
            Element schemaElement = this.getSchema().getElement();
            TypesHelper helper = new TypesHelper(externalSchema);
            String prefix = helper.getPrefix(namespace, false);
            if (map.containsKey(prefix)) {
                prefix = null;
            }
            if (prefix == null || prefix != null && prefix.length() == 0) {
                StringBuffer newPrefix = new StringBuffer("pref");
                int prefixExtension = 1;
                while (map.containsKey(newPrefix.toString()) && prefixExtension < 100) {
                    newPrefix = new StringBuffer("pref" + String.valueOf(prefixExtension));
                    ++prefixExtension;
                }
                prefix = newPrefix.toString();
            }
            if (namespace.length() > 0) {
                if (map.containsValue(namespace)) {
                    TypesHelper typesHelper = new TypesHelper(this.xsdSchema);
                    prefix = typesHelper.getPrefix(namespace, false);
                } else {
                    schemaElement.setAttribute("xmlns:" + prefix, namespace);
                }
                this.prefixText.setText(prefix);
            } else {
                this.prefixText.setText("");
                this.namespaceText.setText("");
            }
            this.endRecording(importElement);
        }
        this.refresh();
    }

    public void refresh() {
        if (this.doRefresh) {
            this.errorText.setText("");
            this.setListenerEnabled(false);
            Element element = null;
            if (this.input instanceof XSDImport) {
                element = ((XSDImportImpl)this.input).getElement();
                String namespace = element.getAttribute("namespace");
                String schemaLocation = element.getAttribute("schemaLocation");
                TypesHelper helper = new TypesHelper(this.xsdSchema);
                String prefix = helper.getPrefix(element.getAttribute("namespace"), false);
                if (namespace == null) {
                    namespace = "";
                }
                if (prefix == null) {
                    prefix = "";
                }
                if (schemaLocation == null) {
                    schemaLocation = "";
                }
                this.namespaceText.setText(namespace);
                this.prefixText.setText(prefix);
                this.schemaLocationText.setText(schemaLocation);
                this.oldPrefixValue = this.prefixText.getText();
            }
            this.setListenerEnabled(true);
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void doHandleEvent(Event event) {
        super.doHandleEvent(event);
        if (event.type == 24 && event.widget == this.prefixText && this.validatePrefix(this.prefixText.getText()) && this.schemaLocationText.getText().trim().length() > 0) {
            Element element = ((XSDConcreteComponent)this.getInput()).getElement();
            Map map = this.getSchema().getQNamePrefixToNamespaceMap();
            if (map.containsKey(this.prefixText.getText())) {
                this.setErrorMessage(XSDEditorPlugin.getXSDString("_ERROR_LABEL_PREFIX_EXISTS"));
            } else {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_PREFIX_CHANGE"), element);
                Element schemaElement = this.getSchema().getElement();
                schemaElement.removeAttribute("xmlns:" + this.oldPrefixValue);
                schemaElement.setAttribute("xmlns:" + this.prefixText.getText(), this.namespaceText.getText());
                XSDSchemaHelper.updateElement((XSDConcreteComponent)this.getSchema());
                this.clearErrorMessage();
                this.oldPrefixValue = this.prefixText.getText();
                this.endRecording(element);
            }
        }
    }
}

